% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmajority.R
\name{cpMajorityComparison}
\alias{cpMajorityComparison}
\alias{cpMajorityComparisonScore}
\title{CP-Majority relation}
\usage{
cpMajorityComparison(
  powerRelation,
  e1,
  e2,
  strictly = FALSE,
  includeEmptySet = TRUE
)

cpMajorityComparisonScore(
  powerRelation,
  e1,
  e2,
  strictly = FALSE,
  includeEmptySet = TRUE
)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{strictly}{Only include \mjeqn{D_{ij}(\succ)}{D_ij(>)} and \mjeqn{D_{ji}(\succ)}{D_ji(>)}, i.e., coalitions
\mjeqn{S \in 2^{N \setminus \lbrace i,j\rbrace}}{S in 2^(N-{i,j})} where
\mjeqn{S \cup \lbrace i\rbrace \succ S \cup \lbrace j\rbrace}{Sui > Suj} and
vice versa.}

\item{includeEmptySet}{If \code{TRUE}, check \mjeqn{\lbrace i \rbrace \succeq \lbrace j \rbrace}{\{i\} >= \{j\}} even if
empty set is not part of the power relation.}
}
\value{
\code{cpMajorityComparison()} returns a list with elements described in the details.

\code{cpMajorityComparisonScore()} returns a vector of two numbers, a positive number of coalitions where \code{e1} beats \code{e2}
(\mjeqn{d_{ij}(\succeq)}{d_ij(>=)}), and a negative number of coalitions where \code{e1} is beaten by \code{e2} (\mjeqn{-d_{ji}(\succeq)}{-d_ji(>=)}).
}
\description{
The Ceteris Paribus-majority relation compares the relative success between two players joining a coalition.

\code{cpMajorityComparisonScore()} only returns two numbers, a positive number of coalitions where \code{e1} beats \code{e2},
and a negative number of coalitions where \code{e1} is beaten by \code{e2}.
}
\details{
\loadmathjax
Given two elements \mjseqn{i} and \mjseqn{j}, go through each coalition \mjeqn{S \in 2^{N \setminus \lbrace i, j \rbrace}}{S in 2^(N - \{i,j\})}.
\mjeqn{D_{ij}(\succeq)}{D_ij(>=)} then contains all coalitions \mjseqn{S} where
\mjeqn{S \cup \lbrace i \rbrace \succeq S \cup \lbrace j \rbrace}{S u \{i\} >= S u \{j\}} and \mjeqn{D_{ji}(\succeq)}{D_ji(>=)} contains all coalitions where
\mjeqn{S \cup \lbrace j \rbrace \succeq S \cup \lbrace i \rbrace}{S u \{j\} >= S u \{i\}}.

The cardinalities
\mjeqn{d_{ij}(\succeq) = |D_{ij}|}{d_ij(>=) = |D_ij|} and
\mjeqn{d_{ji}(\succeq) = |D_{ji}|}{d_ij(>=) = |D_ji|} represent the score of the two elements, where
\mjeqn{i \succ j}{i > j}    if \mjeqn{d_{ij}(\succeq)   >  d_{ji}(\succeq)}{d_ij(>=) >  d_ji(>=)} and
\mjeqn{i \sim  j}{i ~ j}    if \mjeqn{d_{ij}(\succeq)  ==  d_{ji}(\succeq)}{d_ij(>=) == d_ji(>=)}.

\code{\link[=cpMajorityComparison]{cpMajorityComparison()}} tries to retain all that information. The list returned contains the following information.
Note that in this context the two elements \mjseqn{i} and \mjseqn{j} refer to element 1 and element 2 respectively.
\itemize{
\item \verb{$e1}: list of information about element 1
\itemize{
\item \verb{$e1$name}: name of element 1
\item \verb{$e1$score}: score \mjeqn{d_{ij}(\succeq)}{d_ij(>=)}. \mjeqn{d_{ij}(\succ)}{d_ij(>)} if \code{strictly == TRUE}
\item \verb{$e1$winningCoalitions}: list of coalition \code{\link[sets:set]{sets::set}}s \mjeqn{S \in D_{ij}(\succeq)}{S in D_ij(>=)}.  \mjeqn{S \in D_{ij}(\succ)}{S in D_ij(>)} if \code{strictly == TRUE}
}
\item \verb{$e2}: list of information about element 2
\itemize{
\item \verb{$e2$name}: name of element 2
\item \verb{$e1$score}: score \mjeqn{d_{ji}(\succeq)}{d_ji(>=)}. \mjeqn{d_{ji}(\succ)}{d_ji(>)} if \code{strictly == TRUE}
\item \verb{$e1$winningCoalitions}: list of coalition \code{\link[sets:set]{sets::set}}s \mjeqn{S \in D_{ji}(\succeq)}{S in D_ji(>=)}.  \mjeqn{S \in D_{ji}(\succ)}{S in D_ji(>)} if \code{strictly == TRUE}
}
\item \verb{$winner}: name of higher scoring element. \code{NULL} if they are indifferent.
\item \verb{$loser}: name of lower scoring element. \code{NULL} if they are indifferent.
\item \verb{$tuples}: a list of coalitions \mjeqn{S \in 2^{N \setminus \lbrace i, j \rbrace}}{S in 2^(N - \{i,j\})} with:
\itemize{
\item \verb{$tuples[[x]]$coalition}: \code{\link[sets:set]{sets::set}}, the coalition \mjseqn{S}
\item \verb{$tuples[[x]]$included}: logical, \code{TRUE} if \mjeqn{S \cup \lbrace i \rbrace}{Su\{i\}} and \mjeqn{S \cup \lbrace j \rbrace}{Su\{j\}} are in the power relation
\item \verb{$tuples[[x]]$winner}: name of the winning element \mjseqn{i} where \mjeqn{S \cup \lbrace i \rbrace \succ S \cup \lbrace j \rbrace}{S u \{i\} > S u \{j\}}. It is \code{NULL} if \mjeqn{S \cup \lbrace i \rbrace \sim S \cup \lbrace j \rbrace}{S u \{i\} ~ S u \{j\}}
\item \verb{$tuples[[x]]$e1}: index \mjseqn{x_1} at which \mjeqn{S \cup \lbrace i \rbrace \in \sum_{x_1}}{S u \{i\} in Sum_(x_1)}
\item \verb{$tuples[[x]]$e2}: index \mjseqn{x_2} at which \mjeqn{S \cup \lbrace j \rbrace \in \sum_{x_2}}{S u \{j\} in Sum_(x_2)}
}
}

The much more efficient \code{\link[=cpMajorityComparisonScore]{cpMajorityComparisonScore()}} only calculates \verb{$e1$score}.

Unlike Lexcel, Ordinal Banzhaf, etc., this power relation can introduce cycles. For this reason the function
\code{\link[=cpMajorityComparison]{cpMajorityComparison()}} and \code{\link[=cpMajorityComparisonScore]{cpMajorityComparisonScore()}} only offers direct comparisons between two elements
and not a ranking of all players. See the other CP-majority based functions that offer a way to rank all players.
}
\examples{
pr <- newPowerRelationFromString("ac > (a ~ b) > (c ~ bc)")

# a > b
# D_ab = {c, {}}
# D_ba = {{}}
# Score of a = 2
# Score of b = 1
scores <- cpMajorityComparison(pr, "a", "b")
stopifnot(scores$e1$name == "a")
stopifnot(scores$e2$name == "b")
stopifnot(scores$e1$score == 2)
stopifnot(scores$e2$score == 1)
stopifnot(scores$e1$score == length(scores$e1$winningCoalitions))
stopifnot(scores$e2$score == length(scores$e2$winningCoalitions))

# get tuples with coalitions S in 2^(N - \{i,j\})
emptySetTuple <- Filter(function(x) x$coalition == sets::set(), scores$tuples)[[1]]
playerCTuple  <- Filter(function(x) x$coalition == sets::set("c"), scores$tuples)[[1]]

# because {} u a ~ {} u b, there is no winner
stopifnot(is.null(emptySetTuple$winner))
stopifnot(emptySetTuple$e1 == emptySetTuple$e2)

# because c u a > c u b, player "a" gets the score
stopifnot(playerCTuple$winner == "a")
stopifnot(playerCTuple$e1 < playerCTuple$e2)
stopifnot(playerCTuple$e1 == 1L)
stopifnot(playerCTuple$e2 == 3L)

cpMajorityComparisonScore(pr, "a", "b") # c(1,0)
cpMajorityComparisonScore(pr, "b", "a") # c(0,-1)

}
\references{
\insertRef{2018CPMajority}{socialranking}

\insertRef{2018CPMajoritySims}{socialranking}
}
\seealso{
Other CP-majority based functions: 
\code{\link{copelandScores}()},
\code{\link{kramerSimpsonScores}()}
}
\concept{CP-majority based functions}
