% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_delete.r
\name{doc_delete}
\alias{doc_delete}
\title{Delete a document in a database.}
\usage{
doc_delete(cushion, dbname, docid, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{Database name. (charcter)}

\item{docid}{Document ID (character)}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Delete a document in a database.
}
\examples{
\dontrun{
(x <- Cushion$new())

# create a database
if ("sofadb" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="sofadb"))
}
db_create(x, dbname='sofadb')

doc3 <- "<top><a/><b/><c><d/><e>bob</e></c></top>"
doc_create(x, dbname="sofadb", doc=doc3, docid="newnewxml")
doc_delete(x, dbname="sofadb", docid="newnewxml")
doc_delete(x, dbname="sofadb", docid="newnewxml")

# wrong docid name
doc_create(x, dbname="sofadb", doc=doc3, docid="newxml")
doc_delete(x, dbname="sofadb", docid="wrongname")
}
}

