% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods_splr.R
\docType{class}
\name{SparseplusLowRank-class}
\alias{SparseplusLowRank-class}
\alias{\%*\%,ANY,SparseplusLowRank-method}
\alias{\%*\%,SparseplusLowRank,ANY-method}
\alias{\%*\%,Matrix,SparseplusLowRank-method}
\alias{\%*\%,SparseplusLowRank,Matrix-method}
\alias{as.matrix,SparseplusLowRank-method}
\alias{colMeans,SparseplusLowRank-method}
\alias{colSums,SparseplusLowRank-method}
\alias{dim,SparseplusLowRank-method}
\alias{norm,SparseplusLowRank,character-method}
\alias{rowMeans,SparseplusLowRank-method}
\alias{rowSums,SparseplusLowRank-method}
\title{Class \code{"SparseplusLowRank"}}
\description{
A structured matrix made up of a sparse part plus a low-rank part, all which
can be stored and operated on efficiently.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("SparseplusLowRank", ...)} or by a call to \code{splr}
}

\section{Slots}{

\describe{
\item{x}{Object of class \code{"sparseMatrix"}}
\item{a}{Object of class \code{"matrix"}}
\item{b}{Object of class \code{"matrix"}}
}
}

\section{Methods}{

\describe{
\item{\code{\%*\%}}{\code{signature(x = "ANY", y = "SparseplusLowRank")}: ... }
\item{\code{\%*\%}}{\code{signature(x = "SparseplusLowRank", y = "ANY")}: ... }
\item{\code{\%*\%}}{\code{signature(x = "Matrix", y = "SparseplusLowRank")}: ... }
\item{\code{\%*\%}}{\code{signature(x = "SparseplusLowRank", y = "Matrix")}: ... }
\item{\code{as.matrix}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{colMeans}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{colSums}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{dim}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{norm}}{\code{signature(x = "SparseplusLowRank", type = "character")}: ... }
\item{\code{rowMeans}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{rowSums}}{\code{signature(x = "SparseplusLowRank")}: ... }
\item{\code{svd.als}}{\code{signature(x = "SparseplusLowRank")}: ... }
}
}

\examples{

showClass("SparseplusLowRank")
x=matrix(sample(c(3,0),15,replace=TRUE),5,3)
x=as(x,"sparseMatrix")
a=matrix(rnorm(10),5,2)
b=matrix(rnorm(6),3,2)
new("SparseplusLowRank",x=x,a=a,b=b)
splr(x,a,b)
}
\seealso{
\code{softImpute},\code{splr}
}
\author{
Trevor Hastie and Rahul Mazumder
}
\keyword{classes}
