% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softbib.R
\name{softbib}
\alias{softbib}
\title{Software Bibliographies}
\usage{
softbib(
  output = c("softbib.pdf", "softbib.docx", "softbib.bib", "softbib.Rmd"),
  output_dir = getwd(),
  include = NULL,
  exclude = NULL,
  style = NULL
)
}
\arguments{
\item{output}{vector of file paths or \code{NULL}. Acceptable file name extensions: .bib, .Rmd, .docx, .pdf. \code{NULL} returns a vector of BibTeX cite keys.}

\item{output_dir}{path of the directory where files should be saved.}

\item{include}{\code{NULL} or character vector.
\itemize{
\item \code{NULL}: the working directory is crawled to identify \code{R} packages used in the project, and all packages are included in the software bibliography.
\item Character vector: the names of packages to include in the bibliography.
}}

\item{exclude}{character vector of package names to exclude from the bibliography.}

\item{style}{Path to a Citation Style Language file (with \code{.csl} extension) '
Zotero Repository: \url{https://www.zotero.org/styles}}
}
\value{
Writes bibliography to file and returns a character vector of citation keys.
}
\description{
This function detects all the R packages used in a project folder and
automatically creates software bibliographies in PDF, Word, Rmarkdown and
BibTeX formats.
}
\examples{
if (interactive()) {

# Save current path
oldpath <- getwd()

# Navigate to a project folder, crawl the working directory to get a list of `R`
# packages, and create bibliographies
library(softbib)
setwd("~/path/to/my/R/project/")
softbib()

# Exclude some packages from the bibliography
softbib(exclude = c("base", "dplyr"))

# Specify the list of packages to include manually
softbib(include = c("countrycode", "modelsummary", "marginaleffects"))

# Download a Citation Style Language file from the Zotero archive and print a
# bibliography in the style of the American Political Science Review
download.file(
  "https://www.zotero.org/styles/american-political-science-review",
  destfile = "apsr.csl")
softbib(style = "apsr.csl")

# Return to old path
setwd(oldpath)
} # end if(interactive()){}
}
