% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_names.R
\name{experiment_names}
\alias{experiment_names}
\title{Return the names of all experiments in a dataset}
\usage{
experiment_names(x)
}
\arguments{
\item{x}{A \code{softermax} object containing information
about one or more experiments in 'SoftMax Pro'}
}
\value{
A vector of strings
}
\description{
Return the names of all experiments in a dataset
}
\note{
Experiment names are not exported by 'SoftMax Pro' version 6, and data
are grouped under a single experiment, so \code{"unknown"} is returned.
}
\examples{
\dontrun{
d <- read_softmax_xml("myfile.xml")
experiment_names(d)
}
}
