% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncode.R
\name{get_NASIS_metadata}
\alias{get_NASIS_metadata}
\alias{get_NASIS_column_metadata}
\title{Get NASIS Metadata (Domain, Column and Choice Lists)}
\usage{
get_NASIS_metadata(dsn = NULL, include_description = FALSE)

get_NASIS_column_metadata(
  x,
  what = "ColumnPhysicalName",
  include_description = FALSE,
  dsn = NULL
)
}
\arguments{
\item{dsn}{Optional: path to local SQLite database containing NASIS table structure; default: \code{NULL}}

\item{include_description}{Include "ChoiceDescription" column? Default: \code{FALSE}}

\item{x}{character vector to match in NASIS metadata}

\item{what}{Column to match \code{x} against. Default \code{"ColumnPhysicalName"}; alternate options include \code{"DomainID"}, \code{"DomainName"}, \code{"DomainRanked"}, \code{"DisplayLabel"}, \code{"ChoiceSequence"}, \code{"ChoiceValue"}, \code{"ChoiceName"}, \code{"ChoiceLabel"}, \code{"ChoiceObsolete"}, \code{"ChoiceDescription"}, \code{"ColumnLogicalName"}}
}
\value{
a \code{data.frame} containing DomainID, DomainName, DomainRanked, DisplayLabel, ChoiceSequence, ChoiceValue, ChoiceName, ChoiceLabel, ChoiceObsolete, ColumnPhysicalName, ColumnLogicalName and optionally ChoiceDescription when \code{include_description=TRUE}.

a \code{data.frame} containing selected NASIS metadata sorted first on \code{DomainID} and then on \code{ChoiceSequence}
}
\description{
Retrieve a table containing domain and column names with choice list labels/names/sequences/values from the NASIS 7 metadata tables.
}
\details{
These data are derived from the MetadataDomainDetail, MetadataDomainMaster, and MetadataTableColumn tables and help with mapping between values stored in the NASIS database and human-readable values. The human-readable values align with the values returned in public facing interfaces such as SSURGO via Soil Data Access and NASIS Web Reports. The data in these tables can also be used to create \emph{ordered} factors where options for levels of a particular data element follow a logical \code{ChoiceSequence}.

If a local NASIS instance is set up, and this is the first time \code{get_NASIS_metadata()} has been called, the metadata will be obtained from the NASIS local database. Subsequent runs in the same session will use a copy of the data object \code{NASIS.metadata} cached in \code{soilDB.env} which can be accessed with \code{get_soilDB_env()$NASIS.metadata}.

For users without a local NASIS instance, a cached copy of the NASIS metadata are used \code{(data/metadata.rda)}.

See \code{?soilDB::metadata} for additional details.
}
\examples{
get_NASIS_metadata()
get_NASIS_column_metadata("texcl")
}
