% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplifyColorData.R
\name{simplifyColorData}
\alias{simplifyColorData}
\title{Simplify Color Data by ID}
\usage{
simplifyColorData(d, id.var = "phiid", wt = "colorpct", bt = FALSE)
}
\arguments{
\item{d}{a \code{data.frame} object, typically returned from NASIS, see
details}

\item{id.var}{character vector with the name of the column containing an ID
that is unique among all horizons in \code{d}}

\item{wt}{a character vector with the name of the column containing color
weights for mixing}

\item{bt}{logical, should the mixed sRGB representation of soil color be
transformed to closest Munsell chips? This is performed by \code{\link[aqp:col2Munsell]{aqp::col2Munsell()}}}
}
\description{
Simplify multiple Munsell color observations associated with each horizon.

This function is mainly intended for the processing of NASIS pedon/horizon
data which may or may not contain multiple colors per horizon/moisture
status combination. \code{simplifyColorData} will "mix" multiple colors
associated with horizons in \code{d}, according to IDs specified by
\code{id.var}, using "weights" (area percentages) specified by the \code{wt}
argument.

Note that this function doesn't actually simulate the mixture of pigments on
a surface, rather, "mixing" is approximated via weighted average in the
CIELAB colorspace.

The \code{simplifyColorData} function can be applied to data sources other
than NASIS by careful use of the \code{id.var} and \code{wt} arguments.
However, \code{d} must contain Munsell colors split into columns named
"colorhue", "colorvalue", and "colorchroma". In addition, the moisture state
("Dry" or "Moist") must be specified in a column named "colormoistst".

Examples:
\itemize{
\item \href{http://ncss-tech.github.io/AQP/soilDB/KSSL-demo.html}{KSSL data}
\item \href{http://ncss-tech.github.io/AQP/soilDB/mixing-soil-color-data.html}{soil color mixing tutorial}
}
}
\author{
D.E. Beaudette
}
\keyword{manip}
