% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cate_nelson_1971.R
\name{cate_nelson_1971}
\alias{cate_nelson_1971}
\alias{boot_cn_1971}
\title{Cate & Nelson quadrants analysis (statistical)}
\usage{
cate_nelson_1971(data = NULL, stv, ry, tidy = TRUE, plot = FALSE)

boot_cn_1971(data, ry, stv, n = 5, ...)
}
\arguments{
\item{data}{argument to call a data.frame or data.table containing the data}

\item{stv}{argument to call the vector or column containing the soil test value (stv) data}

\item{ry}{argument to call the vector or column containing the relative yield (ry) data}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a data.frame, FALSE returns a list. Default: TRUE.}

\item{plot}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a ggplot,
FALSE returns either a list (tidy == FALSE) or a data.frame (tidy == TRUE).}

\item{n}{sample size for the bootstrapping Default: 500}

\item{...}{when running bootstrapped samples, the \code{...} (open arguments) allows to add grouping variable/s (factor or character) Default: NULL}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.

boot_cn_1971: bootstrapping function
}
\description{
This function runs the quadrants analysis suggested by Cate and Nelson (1971)
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/cate_nelson_1971_tutorial.html}{online-documentation} for additional details.
}
\note{
This code was adapted from
Mangiafico, S. S. (2013). Cate-Nelson Analysis for Bivariate Data Using R-project.
\emph{The Journal of Extension, 51(5), Article 33.} \url{https://tigerprints.clemson.edu/joe/vol51/iss5/33/}
}
\examples{
\donttest{
 # Example 1 dataset
 dat <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                   "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example_cn_1971 <- cate_nelson_1971(data = dat, 
 ry = ry, stv = stv, tidy=FALSE, plot=FALSE)
 
 fit_example_cn_1971
}
}
\references{
Cate & Nelson (1971).
A simple statistical procedure for partitioning soil test correlation data into two classes.
\emph{Soil Sci. Soc. Am. Proc. 35:658-660.} \doi{10.2136/sssaj1971.03615995003500040048x}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[stats]{lm}},\code{\link[stats]{anova}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{theme}}
}
