% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_deleteshard.R
\name{collection_deleteshard}
\alias{collection_deleteshard}
\title{Delete a shard}
\usage{
collection_deleteshard(name, shard, raw = FALSE, ...)
}
\arguments{
\item{name}{(character) Required. The name of the collection that includes the shard
to be deleted}

\item{shard}{(character) Required. The name of the shard to be deleted}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Deleting a shard will unload all replicas of the shard and remove
them from clusterstate.json. It will only remove shards that are inactive, or
which have no range given for custom sharding.
}
\examples{
\dontrun{
solr_connect()
# create collection
# collection_create(name = "buffalo") # bin/solr create -c buffalo

# find shard names
names(collection_clusterstatus()$cluster$collections$buffalo$shards)
# split a shard by name
collection_splitshard(name = "buffalo", shard = "shard1")
# now we have three shards
names(collection_clusterstatus()$cluster$collections$buffalo$shards)

# delete shard
collection_deleteshard(name = "buffalo", shard = "shard1_1")
}
}

