% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_search.R
\name{GlobalSearch.request}
\alias{GlobalSearch.request}
\title{GlobalSearch.request}
\usage{
GlobalSearch.request(
  query = NULL,
  filters,
  entities,
  env = solvebio:::.solveEnv,
  ...
)
}
\arguments{
\item{query}{(optional) Advanced search query.}

\item{filters}{(optional) Low-level filter specification.}

\item{entities}{(optional) Low-level entity specification.}

\item{env}{(optional) Custom client environment.}

\item{...}{(optional) Additional query parameters (e.g. limit, offset).}
}
\description{
Performs low-level Global Search based on the provided filters, queries and entities.
Returns full API response (containing attributes: results, vaults, subjects, subjects_count, total, took and offset)
}
\examples{
\dontrun{
# No filters are applied
GlobalSearch.request()

# Global Beacon search
GlobalSearch.request(entities = '[["gene","BRCA2"]]')

# Type filter (only vaults)
GlobalSearch.request(filters = '[{"and":[["type__in",["vault"]]]}]')

# Advanced search
GlobalSearch.request(query = "fuji")


# Multiple filters and entities
GlobalSearch.request(
  entities = '[["gene","BRCA2"]]',
  filters = '[{
               "and": [
                      {"and": [
                         ["created_at__range",["2021-11-28","2021-12-28"]]]},
                         ["type__in",["dataset"]]
                     ]
             }]'
)
}

}
\references{
\url{https://docs.solvebio.com/}
}
