% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.distance.functions.R
\name{dist.fun.tricubic}
\alias{dist.fun.tricubic}
\title{Tricubic distance functions for topological k-NN classifier}
\usage{
dist.fun.tricubic(x, sigma = 1)
}
\arguments{
\item{x}{Distance or \code{numeric} vector or matrix of distances.}

\item{sigma}{Maximum distance to be considered.}
}
\value{
Distance-dependent weight.
}
\description{
The tricubic function is used as distance-dependent weight \eqn{w} for
k-NN voting.
}
\details{
The function returns 1.0 for \eqn{x = 0}, 0.0 for \eqn{x \ge \sigma} and

\deqn{w(x) = (1 - x^3 / \sigma^3)^3}

for \eqn{0 < x < \sigma}.
}

