% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{tabAbs2Rel}
\alias{tabAbs2Rel}
\title{Convert a table from absolute to relative values.}
\usage{
tabAbs2Rel(tab, column)
}
\arguments{
\item{tab}{[table] The contingency table with sound correspondences.}

\item{column}{[character] Do columns contain the same data as rows (\code{NULL}) or some other data (a string)?}
}
\value{
[table] The converted table.
}
\description{
Cross-tabulating sound correspondences with themselves may be misleading if the values are absolute, as it may well be that some segments simply do co-occur frequently, while others only rarely. The conversion is done in blocks: rows with the same prefix vs cols with the same prefix (if \code{column = NULL}) or vs all columns (if \code{column} is a string).
}
\examples{
dataset <- sampleSoundCorrsData.abc
soundcorrs:::tabAbs2Rel (table(dataset,unit="o",direction=2), NULL)
}
\keyword{internal}
