% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{table.soundcorrs}
\alias{table.soundcorrs}
\title{Generate a correspondence-to-correspondence or correspondence-to-metadata contingency table.}
\usage{
\method{table}{soundcorrs}(data, column = NULL, count = "a", unit = "w", direction = 1, ...)
}
\arguments{
\item{data}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{column}{[character] Name of the column with metadata. If \code{NULL}, sound correspondences are cross-tabulated with themselves. Defaults to \code{NULL}.}

\item{count}{[character] Report the absolute number of times or words, or relative to how many times or in how many words the given segments co-occur in L1 or L2. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{direction}{[integer] If \code{1}, correspondences are in the order Language1 > Language2 ("x yields y"). If \code{2}, the order is Language2 < Language1 ("y originates from x"). Defaults to \code{1}.}

\item{...}{Unused; only for consistency with \code{\link{table}}.}
}
\value{
[table] The contingency table.
}
\description{
Take all segment-to-segment correspondences in a dataset, and cross-tabulate them with themselves or with metadata taken from a separate column.
}
\examples{
dataset <- sampleSoundCorrsData.abc
table (dataset)
table (dataset, direction=2)
table (dataset, "DIALECT.L2")
round (table(dataset,"DIALECT.L2",count="r"), digits=3)
}
