% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{allPairs}
\alias{allPairs}
\title{Produce a list of all sound correspondences and all pairs in which they are attested.}
\usage{
allPairs(data, file, count, unit, direction, cols, formatter, ...)
}
\arguments{
\item{data}{[character] The dataset. Only datasets with two languages are supported.}

\item{file}{[character] Name of the file to write the formatted list to. If \code{NULL}, the output will be printed to the screen. Defaults to \code{NULL}.}

\item{count}{[character] Report the absolute number of times or words, or relative to how many times or in how many words the given segments co-occur in L1 or L2. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{direction}{[integer] If \code{1}, correspondences are in the order Language1 > Language2 ("x yields y"). If \code{2}, the order is Language2 < Language1 ("y originates from x"). Defaults to \code{1}.}

\item{cols}{[character vector] Which columns of the dataset to print. Can be a vector of names, \code{"aligned"} (the two columns with segmented, aligned words), or \code{"all"} (all columns). Defaults to \code{"aligned"}.}

\item{formatter}{[function] The function to which to pass unformatted data. Available formatters are: \code{formatter.none}, \code{formatter.html}, and \code{formatter.latex}. Defaults to \code{formatter.none}.}

\item{...}{Additional arguments passed to \code{formatter}.}
}
\description{
Take all segment-to-segment correspondences in the dataset, and produce for each a section composed of a title, a contingency table of all renderings of the given segment, and subsections listing all word pairs in which the given rendering is attested, all nicely formatted.
}
\examples{
dataset <- sampleSoundCorrsData.abc
allPairs (dataset)
allPairs (dataset, formatter=formatter.latex, cols=c("ORTHOGRAPHY.L1","ORTHOGRAPHY.L2"))
}
