% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{formatter.none}
\alias{formatter.none}
\title{A formatter for \code{\link{allPairs}}. This one does practically no formatting at all.}
\usage{
formatter.none(what, x, direction = 1)
}
\arguments{
\item{what}{[character] What type of data is \code{x}.}

\item{x}{The object to be formatted.}

\item{direction}{[integer] If 1, correspondences are in the order Language1 > Language2 ("x yields y"). If 2, the order is Language2 < Language1 ("y originates from x"). Defaults to 1.}
}
\value{
[character] Formatted x.
}
\description{
A formatter for \code{\link{allPairs}}. This one does practically no formatting at all.
}
\examples{
# prepare sample dataset
fTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
fData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
tmp.ger <- read.soundcorrs (fData, "German", "ALIGNED.German", fTrans)
tmp.pol <- read.soundcorrs (fData, "Polish", "ALIGNED.Polish", fTrans)
dataset <- merge (tmp.ger, tmp.pol)
# run allPairs
allPairs (dataset, unit="o", formatter=formatter.none)
}
