% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{tabAbs2Rel}
\alias{tabAbs2Rel}
\title{Convert a table from absolute to relative values.}
\usage{
tabAbs2Rel(tab, column)
}
\arguments{
\item{tab}{[table] The contingency table with sound correspondences.}

\item{column}{[character] Do columns contain the same data as rows (\code{NULL}) or some other data (a string)?}
}
\value{
[table] The converted table.
}
\description{
Cross-tabulating sound correspondences with themselves may be misleading if the values are absolute, as it may well be that some segments simply do co-occur frequently, while others only rarely. The conversion is done in blocks: rows with the same prefix vs cols with the same prefix (if \code{column = NULL}) or vs all columns (if \code{column} is a string).
}
\details{
Functions that produce contingency tables, \code{\link{coocc}} and \code{\link{summary}}, return a result in absolute numbers, but sometimes the relative perspective may be more useful. This function converts from absolute to relative, but it does so in blocks where each block is an intersection of all the columns and the all rows whose names begin with the same prefix. 'Prefix' in this case is whatever comes before an underscore (\code{"_"}), because \code{\link{coocc}} and others use underscore to connect names of columns and rows.
}
\examples{
dataset <- loadSampleDataset ("data-abc")
soundcorrs:::tabAbs2Rel (coocc(dataset,unit="o"), NULL)
}
\keyword{internal}
