% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{wide2long}
\alias{wide2long}
\title{Convert from the wide format (multiple entries per row) to the long format (single entry per row).}
\usage{
wide2long(data, suffixes, col.lang = "LANGUAGE", strip = 0)
}
\arguments{
\item{data}{[data.frame] The dataset to be converted.}

\item{suffixes}{[character vector] Suffixes used to differentiate column names; in the output, those will be used as language names.}

\item{col.lang}{[character] Name of the column in which language names are to be stored. Defaults to \code{"LANGUAGE"}.}

\item{strip}{[integer] The number of characters to strip from the beginning of suffixes when they are turned into language names. Defaults to 0.}
}
\value{
[data.frame] A data frame in the long format (single entry per row).
}
\description{
Takes a data frame of word pairs/triples/..., each stored in a single row, and returns a data frame with the same pairs/triples/... but with each word stored in its own row.
}
\details{
Data for \code{\link{soundcorrs}} can be prepared in one of two formats: the 'long format' and the 'wide format'. In the 'long format', each row contains only a single word and metadata associated with it. In the 'wide format', each row contains the entire pair/triple/... of words, and all the metadata associated with them. The 'long format' is convenient for making sure that all the words in a pair/triple/... have the same number of segments, but it cannot be read directly by \code{\link{soundcorrs}}. \code{\link{long2wide}} and \code{wide2long} convert between the two formats.
}
\examples{
# path to sample data in the "wide format"
fName <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
wide <- read.table (fName, header=TRUE)
long <- wide2long (wide, c(".German",".Polish",".Spanish"), strip=1)
}
\seealso{
\code{\link{long2wide}}
}
