% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundgen.R
\name{soundgen}
\alias{soundgen}
\title{Generate a sound}
\usage{
soundgen(repeatBout = 1, nSyl = 1, sylLen = 300, pauseLen = 200,
  pitchAnchors = data.frame(time = c(0, 0.1, 0.9, 1), value = c(100, 150, 135,
  100)), pitchAnchorsGlobal = NA, glottisAnchors = 0, temperature = 0.025,
  tempEffects = list(), maleFemale = 0, creakyBreathy = 0,
  nonlinBalance = 0, nonlinDep = 50, nonlinRandomWalk = NULL,
  jitterLen = 1, jitterDep = 1, vibratoFreq = 5, vibratoDep = 0,
  shimmerDep = 0, shimmerLen = 1, attackLen = 50, rolloff = -9,
  rolloffOct = -3, rolloffKHz = -3, rolloffParab = 0,
  rolloffParabHarm = 3, lipRad = 6, noseRad = 4, mouthOpenThres = 0,
  formants = c(860, 1430, 2900), formantDep = 1, formantDepStoch = 20,
  formantWidth = 1, vocalTract = NA, subFreq = 100, subDep = 100,
  shortestEpoch = 300, amDep = 0, amFreq = 30, amShape = 0,
  noiseAnchors = NULL, formantsNoise = NA, rolloffNoise = -4,
  noiseFlatSpec = 1200, mouthAnchors = data.frame(time = c(0, 1), value =
  c(0.5, 0.5)), amplAnchors = NA, amplAnchorsGlobal = NA,
  interpol = c("approx", "spline", "loess")[3], discontThres = 0.05,
  jumpThres = 0.01, samplingRate = 16000, windowLength = 50,
  overlap = 75, addSilence = 100, pitchFloor = 1, pitchCeiling = 3500,
  pitchSamplingRate = 3500, throwaway = -80,
  invalidArgAction = c("adjust", "abort", "ignore")[1], plot = FALSE,
  play = FALSE, savePath = NA, ...)
}
\arguments{
\item{repeatBout}{number of times the whole bout should be repeated}

\item{nSyl}{number of syllables in the bout. Intonation, amplitude, and
formants contours span multiple syllables, but not multiple bouts}

\item{sylLen}{average duration of each syllable, ms}

\item{pauseLen}{average duration of pauses between syllables, ms (can be
negative between bouts: force with invalidArgAction = 'ignore')}

\item{pitchAnchors}{a numeric vector of f0 values in Hz or a dataframe
specifying the time (ms or 0 to 1) and value (Hz) of each anchor. These
anchors are used to create a smooth contour of fundamental frequency f0
(pitch) within one syllable}

\item{pitchAnchorsGlobal}{unlike \code{pitchAnchors}, these anchors are used
to create a smooth contour of average f0 across multiple syllables. The
values are in semitones relative to the existing pitch, i.e. 0 = no change}

\item{glottisAnchors}{anchors for specifying the proportion of a glottal
cycle with closed glottis, % (0 = no modification, 100 = closed phase as
long as open phase); numeric vector or dataframe specifying time and value}

\item{temperature}{hyperparameter for regulating the amount of stochasticity
in sound generation}

\item{tempEffects}{a list of scaling coefficients regulating the effect of
temperature on particular parameters. To change, specify just those pars
that you want to modify (default is 1 for all of them). \code{sylLenDep}:
duration of syllables and pauses; \code{formDrift}: formant frequencies;
\code{formDisp}: dispersion of stochastic formants; \code{pitchDriftDep}:
amount of slow random drift of f0; \code{pitchDriftFreq}: frequency of slow
random drift of f0; \code{amplDriftDep}: drift of amplitude mirroring pitch
drift; \code{subDriftDep}: drift of subharmonic frequency and bandwidth
mirroring pitch drift; \code{rolloffDriftDep}: drift of rolloff mirroring
pitch drift; \code{pitchAnchorsDep, noiseAnchorsDep, amplAnchorsDep}:
random fluctuations of user-specified pitch / noise / amplitude anchors;
\code{glottisAnchorsDep}: proportion of glottal cycle with closed glottis;
\code{specDep}: rolloff, nonlinear effects, attack}

\item{maleFemale}{hyperparameter for shifting f0 contour, formants, and
vocalTract to make the speaker appear more male (-1...0) or more female
(0...+1); 0 = no change}

\item{creakyBreathy}{hyperparameter for a rough adjustment of voice quality
from creaky (-1) to breathy (+1); 0 = no change}

\item{nonlinBalance}{hyperparameter for regulating the (approximate)
proportion of sound with different regimes of pitch effects (none /
subharmonics only / subharmonics and jitter). 0\% = no noise; 100\% = the
entire sound has jitter + subharmonics. Ignored if temperature = 0}

\item{nonlinDep}{hyperparameter for regulating the intensity of
subharmonics and jitter, 0 to 100\% (50\% = jitter and subharmonics are as
specified, <50\% weaker, >50\% stronger). Ignored if temperature = 0}

\item{nonlinRandomWalk}{a numeric vector specifying the timing of nonliner
regimes: 0 = none, 1 = subharmonics, 2 = subharmonics + jitter + shimmer}

\item{jitterLen}{duration of stable periods between pitch jumps, ms. Use a
low value for harsh noise, a high value for irregular vibrato or shaky
voice (vectorized)}

\item{jitterDep}{cycle-to-cycle random pitch variation, semitones (vectorized)}

\item{vibratoFreq}{the rate of regular pitch modulation, or vibrato, Hz (vectorized)}

\item{vibratoDep}{the depth of vibrato, semitones (vectorized)}

\item{shimmerDep}{random variation in amplitude between individual glottal
cycles (0 to 100\% of original amplitude of each cycle) (vectorized)}

\item{shimmerLen}{duration of stable periods between amplitude jumps, ms. Use
a low value for harsh noise, a high value for shaky voice (vectorized)}

\item{attackLen}{duration of fade-in / fade-out at each end of syllables and
noise (ms): a vector of length 1 (symmetric) or 2 (separately for fade-in
and fade-out)}

\item{rolloff}{basic rolloff from lower to upper harmonics, db/octave
(exponential decay). All rolloff parameters are vectorized. See
\code{\link{getRolloff}} for more details}

\item{rolloffOct}{basic rolloff changes from lower to upper
harmonics (regardless of f0) by \code{rolloffOct} dB/oct. For
example, we can get steeper rolloff in the upper part of the spectrum}

\item{rolloffKHz}{rolloff changes linearly with f0 by
\code{rolloffKHz} dB/kHz. For ex., -6 dB/kHz gives a 6 dB
steeper basic rolloff as f0 goes up by 1000 Hz}

\item{rolloffParab}{an optional quadratic term affecting only the
first \code{rolloffParabHarm} harmonics. The middle harmonic
of the first \code{rolloffParabHarm} harmonics is amplified or
dampened by \code{rolloffParab} dB relative to the basic
exponential decay}

\item{rolloffParabHarm}{the number of harmonics affected by
\code{rolloffParab}}

\item{lipRad}{the effect of lip radiation on source spectrum, dB/oct
(the default of +6 dB/oct produces a high-frequency boost when the mouth is
open)}

\item{noseRad}{the effect of radiation through the nose on source
spectrum, dB/oct (the alternative to \code{lipRad} when the mouth is
closed)}

\item{mouthOpenThres}{open the lips (switch from nose radiation to lip
radiation) when the mouth is more than \code{mouthOpenThres} open, 0 to 1}

\item{formants}{either a character string like "aaui" referring to default
presets for speaker "M1" or a list of formant times, frequencies,
amplitudes, and bandwidths (see ex. below). \code{formants = NA} defaults
to schwa. Time stamps for formants and mouthOpening can be specified in ms
or an any other arbitrary scale. See \code{\link{getSpectralEnvelope}} for more details}

\item{formantDep}{scale factor of formant amplitude (1 = no change relative
to amplitudes in \code{formants})}

\item{formantDepStoch}{the amplitude of additional stochastic formants added above
the highest specified formant, dB (only if temperature > 0)}

\item{formantWidth}{= scale factor of formant bandwidth (1 = no change)}

\item{vocalTract}{the length of vocal tract, cm. Used for calculating formant
dispersion (for adding extra formants) and formant transitions as the mouth
opens and closes. If \code{NULL} or \code{NA}, the length is estimated
based on specified formant frequencies (if any)}

\item{subFreq}{target frequency of subharmonics, Hz (lower than f0, adjusted
dynamically so f0 is always a multiple of subFreq)}

\item{subDep}{the width of subharmonic band, Hz. Regulates how quickly the
strength of subharmonics fades as they move away from harmonics in f0
stack. Low values produce narrow sidebands, high values produce uniformly
strong subharmonics}

\item{shortestEpoch}{minimum duration of each epoch with unchanging
subharmonics regime, in ms}

\item{amDep}{amplitude modulation depth, \%. 0: no change; 100: amplitude
modulation with amplitude range equal to the dynamic range of the sound}

\item{amFreq}{amplitude modulation frequency, Hz (vectorized)}

\item{amShape}{amplitude modulation shape (-1 to +1, defaults to 0)
(vectorized)}

\item{noiseAnchors}{a numeric vector of noise amplitudes (throwaway dB = none, 0
dB = as loud as voiced component) or a dataframe specifying the time (ms)
and amplitude (dB) of anchors for generating the noise component such as
aspiration, hissing, etc}

\item{formantsNoise}{the same as \code{formants}, but for the
unvoiced component instead of the voiced component. If NA (default), the
unvoiced component will be filtered through the same formants as the voiced
component, approximating aspiration noise [h]}

\item{rolloffNoise}{linear rolloff of the excitation source for the unvoiced
component, dB/kHz (vectorized)}

\item{noiseFlatSpec}{keeps noise spectrum flat to this frequency, Hz}

\item{mouthAnchors}{a numeric vector of mouth opening (0 to 1, 0.5 = neutral,
i.e. no modification) or a dataframe specifying the time (ms) and value of
mouth opening}

\item{amplAnchors}{a numeric vector of amplitude envelope (dB) or a dataframe
specifying the time (ms) and value of amplitude anchors (0 = max amplitude)}

\item{amplAnchorsGlobal}{a numeric vector of global amplitude envelope
spanning multiple syllables or a dataframe specifying the time (ms) and
value (dB) of each anchor; 0 = no change}

\item{interpol}{the method of smoothing envelopes based on provided anchors:
'approx' = linear interpolation, 'spline' = cubic spline, 'loess' (default)
= polynomial local smoothing function. NB: this does not affect
noiseAnchors, glottalAnchors, and the smoothing of formants}

\item{discontThres, jumpThres}{if two anchors are closer in time than
\code{discontThres}, the contour is broken into segments with a linear
transition between these anchors; if anchors are closer than
\code{jumpThres}, a new section starts with no transition at all (e.g. for
adding pitch jumps)}

\item{samplingRate}{sampling frequency, Hz}

\item{windowLength}{length of FFT window, ms}

\item{overlap}{FFT window overlap, \%. For allowed values, see
\code{\link[seewave]{istft}}}

\item{addSilence}{silence before and after the bout, ms}

\item{pitchFloor, pitchCeiling}{lower & upper bounds of f0}

\item{pitchSamplingRate}{sampling frequency of the pitch contour only, Hz.
Low values reduce processing time. A rule of thumb is to set this to the
same value as \code{pitchCeiling} for optimal speed and to
\code{samplingRate} for optimal quality}

\item{throwaway}{discard harmonics and noise that are quieter than this
number (in dB, defaults to -80) to save computational resources}

\item{invalidArgAction}{what to do if an argument is invalid or outside the
range in \code{permittedValues}: 'adjust' = reset to default value, 'abort'
= stop execution, 'ignore' = throw a warning and continue (may crash)}

\item{plot}{if TRUE, plots a spectrogram}

\item{play}{if TRUE, plays the synthesized sound. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}

\item{savePath}{full path for saving the output, e.g. '~/Downloads/temp.wav'.
If NA (default), doesn't save anything}

\item{...}{other plotting parameters passed to \code{\link{spectrogram}}}
}
\value{
Returns the synthesized waveform as a numeric vector.
}
\description{
Generates a bout of one or more syllables with pauses between them. Two basic
components are synthesized: the harmonic component (the sum of sine waves
with frequencies that are multiples of the fundamental frequency) and the
noise component. Both components can be filtered with independently specified
formants. Intonation and amplitude contours can be applied both within each
syllable and across multiple syllables. Suggested application: synthesis of
animal or human non-linguistic vocalizations. For more information, see
\url{http://cogsci.se/soundgen.html} and the vignette on sound generation.
}
\examples{
# NB: GUI for soundgen is available as a Shiny app.
# Type "soundgen_app()" to start it

playback = c(TRUE, FALSE)[2]  # set to TRUE to play back the audio from examples

sound = soundgen(play = playback)
# spectrogram(sound, 16000, osc = TRUE)
# playme(sound)

# Use the in-built collection of presets:
# names(presets)  # speakers
# names(presets$Chimpanzee)  # calls per speaker
s1 = eval(parse(text = presets$Chimpanzee$Scream_conflict))  # screaming chimp
# playme(s1)
s2 = eval(parse(text = presets$F1$Scream))
# playme(s2)
\dontrun{
# unless temperature is 0, the sound is different every time
for (i in 1:3) sound = soundgen(play = playback, temperature = .2)

# Bouts versus syllables. Compare:
sound = soundgen(formants = 'uai', repeatBout = 3, play = playback)
sound = soundgen(formants = 'uai', nSyl = 3, play = playback)

# Intonation contours per syllable and globally:
sound = soundgen(nSyl = 5, sylLen = 200, pauseLen = 140,
  play = playback, pitchAnchors = data.frame(
    time = c(0, 0.65, 1), value = c(977, 1540, 826)),
  pitchAnchorsGlobal = data.frame(time = c(0, .5, 1), value = c(-6, 7, 0)))

# Subharmonics in sidebands (noisy scream)
sound = soundgen (nonlinBalance = 100, subFreq = 75, subDep = 130,
  pitchAnchors = data.frame(
    time = c(0, .3, .9, 1), value = c(1200, 1547, 1487, 1154)),
  sylLen = 800,
  play = playback, plot = TRUE)

# Jitter and mouth opening (bark, dog-like)
sound = soundgen(repeatBout = 2, sylLen = 160, pauseLen = 100,
  nonlinBalance = 100, subFreq = 100, subDep = 60, jitterDep = 1,
  pitchAnchors = c(559, 785, 557),
  mouthAnchors = c(0, 0.5, 0),
  vocalTract = 5, play = playback)

# Use nonlinRandomWalk to crease reproducible examples of sounds with
nonlinear effects. For ex., to make a sound with no effect in the first
third, subharmonics in the second third, and jitter in the final third of the
total duration:
a = c(rep(0, 100), rep(1, 100), rep(2, 100))
s = soundgen(sylLen = 800, pitchAnchors = 300, temperature = 0.001,
             subFreq = 100, subDep = 70, jitterDep = 1,
             nonlinRandomWalk = a, plot = TRUE, ylim = c(0, 4))
# playme(s)

# See the vignette on sound generation for more examples and in-depth
# explanation of the arguments to soundgen()
}
}
