% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{findVoicedSegments}
\alias{findVoicedSegments}
\title{Find voiced segments}
\usage{
findVoicedSegments(pitchCands, shortestSyl, shortestPause, step,
  samplingRate, minVoicedCands, pitchMethods, manualV = NULL,
  manualUnv = NULL)
}
\arguments{
\item{pitchCands}{matrix of possible pitch values per column. One column is
one fft frame, one row is one pitch candidate}

\item{shortestSyl}{the smallest length of a voiced segment (ms) that
constitutes a voiced syllable (shorter segments will be replaced by NA, as
if unvoiced)}

\item{shortestPause}{the smallest gap between voiced syllables (ms) that
means they shouldn't be merged into one voiced syllable}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{samplingRate}{sampling rate (Hz)}

\item{minVoicedCands}{a frame is considered to be voiced if at least this
many pitch candidates are not NA. Defaults to 2: since dom is usually
defined, in practice this means that we also want at least one other pitch
candidate (autocor, cep or BaNa)}

\item{pitchMethods}{methods of pitch tracking in analyze()}
}
\value{
Returns a dataframe specifying where each voiced segment starts and
  ends (in fft frames, not ms!)
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing of pitch contours. Merges voiced
segments at least \code{shortestSyl} ms long and separated by less than
\code{shortestPause} ms. Called by \code{\link{analyze}}
}
\keyword{internal}
