% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum.R
\name{modulationSpectrumFolder}
\alias{modulationSpectrumFolder}
\title{Modulation spectrum per folder}
\usage{
modulationSpectrumFolder(myfolder, summary = TRUE, htmlPlots = TRUE,
  verbose = TRUE, maxDur = 5, logSpec = FALSE, windowLength = 25,
  step = NULL, overlap = 80, wn = "gaussian", zp = 0, power = 1,
  roughRange = c(30, 150), plot = FALSE, savePlots = FALSE,
  logWarp = 2, quantiles = c(0.5, 0.8, 0.9), kernelSize = 5,
  kernelSD = 0.5, colorTheme = c("bw", "seewave", "...")[1],
  xlab = "Hz", ylab = "1/KHz", width = 900, height = 500,
  units = "px", res = NA, ...)
}
\arguments{
\item{myfolder}{full path to target folder}

\item{summary}{if TRUE, returns only a summary of the measured acoustic
variables (mean, median and SD). If FALSE, returns a list containing
frame-by-frame values}

\item{htmlPlots}{if TRUE, saves an html file with clickable plots}

\item{verbose}{if TRUE, reports progress and estimated time left}

\item{maxDur}{maximum allowed duration of a single sound, s (longer sounds
are split)}

\item{logSpec}{if TRUE, the spectrogram is log-transformed prior to taking 2D
FFT}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type: gaussian, hanning, hamming, bartlett, rectangular,
blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{power}{raise modulation spectrum to this power (eg power = 2 for ^2, or
"power spectrum")}

\item{roughRange}{the range of temporal modulation frequencies that
constitute the "roughness" zone, Hz}

\item{plot}{if TRUE, produces a spectrogram with pitch contour overlaid}

\item{savePlots}{if TRUE, saves plots as .png files}

\item{logWarp}{the base of log for warping the modulation spectrum (ie log2
if logWarp = 2); set to NULL or NA if you don't want to log-warp}

\item{quantiles}{labeled contour values, \% (e.g., "50" marks regions that
contain 50\% of the sum total of the entire modulation spectrum)}

\item{kernelSize}{the size of Gaussian kernel used for smoothing (1 = no
smoothing)}

\item{kernelSD}{the SD of Gaussian kernel used for smoothing, relative to its
size}

\item{colorTheme}{black and white ('bw'), as in seewave package ('seewave'),
or any palette from \code{\link[grDevices]{palette}} such as 'heat.colors',
'cm.colors', etc}

\item{xlab}{plotting parameters}

\item{ylab}{plotting parameters}

\item{width}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{height}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{units}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{...}{other graphical parameters passed to \code{\link{spectrogram}}}
}
\value{
If \code{summary} is TRUE, returns a dataframe with just the
  roughness measure per audio file. If \code{summary} is FALSE, returns a
  list with the actual modulation spectra.
}
\description{
Extracts modulation spectra of all wav/mp3 files in a folder - separately for
each file, without averaging. Good for saving plots of the modulation spectra
and/or measuring the roughness of multiple files. See
\code{\link{modulationSpectrum}} for further details.
}
\examples{
\dontrun{
ms = modulationSpectrumFolder('~/Downloads/temp', savePlots = TRUE, kernelSize = 15)
}
}
\seealso{
\code{\link{modulationSpectrum}}
}
