% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{intplPitch}
\alias{intplPitch}
\title{Interpolate pitch contour}
\usage{
intplPitch(pitch, idx_unv = NULL)
}
\arguments{
\item{pitch}{numeric vector of pitch values (NA = unvoiced)}

\item{idx_unv}{which(is.na(pitch))}
}
\value{
Returns the same numeric vector with NAs filled in by interpolation.
}
\description{
Internal soundgen function
}
\details{
Takes in a pitch contour and fills up the unvoiced gaps (NAs) by linear
interpolation in the middle and constant interpolation at the ends. Called by
pitchSmoothPraat().
}
\examples{
soundgen:::intplPitch(c(NA, 405, 441, 460, NA, NA, NA, 480, 490, NA, NA))
}
\keyword{internal}
