% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{getPitchCep}
\alias{getPitchCep}
\title{Cepstral pitch tracker}
\usage{
getPitchCep(
  frame,
  samplingRate,
  nCands,
  cepThres,
  cepSmooth,
  cepZp,
  pitchFloor,
  pitchCeiling
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{samplingRate}{sampling rate (Hz)}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}

\item{cepThres}{voicing threshold (unitless, ~0 to 1)}

\item{cepSmooth}{the width of smoothing interval (Hz) for finding peaks in
the cepstrum}

\item{cepZp}{zero-padding of the spectrum used for cepstral pitch detection
(final length of spectrum after zero-padding in points, e.g. 2 ^ 13)}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}
}
\value{
Returns either NULL or a dataframe of pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by looking for peaks in the cepstrum.
See http://www.phon.ucl.ac.uk/courses/spsci/matlab/lect10.html
}
\keyword{internal}
