% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subharmonics.R
\name{getVocalFry}
\alias{getVocalFry}
\title{Subharmonics}
\usage{
getVocalFry(
  rolloff,
  pitch_per_gc,
  subRatio = 2,
  subFreq = 0,
  subDep = 10,
  subWidth = 10000,
  dynamicRange = 80,
  shortestEpoch = 300
)
}
\arguments{
\item{rolloff}{matrix of original amplitudes of each harmonic in f0 stack
returned by \code{\link{getRolloff}} (columns=time, rows=frequency bins)}

\item{pitch_per_gc}{vector of the same length as ncol(rolloff)): f0 in Hz,
one value per glottal cycle}

\item{subRatio}{a positive integer giving the ratio of f0 (the main
fundamental) to g0 (a lower frequency): 1 = no subharmonics, 2 = period
doubling regardless of pitch changes, 3 = period tripling, etc; subRatio
overrides subFreq (anchor format)}

\item{subFreq}{instead of a specific number of subharmonics (subRatio), we
can specify the approximate g0 frequency (Hz), which is used only if
subRatio = 1 and is adjusted to f0 so f0/g0 is always an integer (anchor
format)}

\item{subDep}{the depth of subharmonics relative to the main frequency
component (f0), \%. 0: no subharmonics; 100: g0 harmonics are as strong as
the nearest f0 harmonic (anchor format)}

\item{subWidth}{Width of subharmonic sidebands - regulates how rapidly
g-harmonics weaken away from f-harmonics: large values like the default
10000 means that all g0 harmonics are equally strong (anchor format)}

\item{dynamicRange}{dynamic range, dB. Harmonics and noise more than
dynamicRange under maximum amplitude are discarded to save computational
resources}

\item{shortestEpoch}{minimum duration of each epoch with unchanging
subharmonics regime or formant locking, in ms}
}
\value{
Returns a list consisting of a list of rolloff matrices (one matrix
  per epoch) and a dataframe of epochs.
}
\description{
Internal soundgen function.
}
\details{
Adds subharmonics to the main (f0) harmonic stack, forming sidebands.
}
\examples{
pitch_per_gc = c(400, 500, 600, 700)
rolloff = getRolloff(pitch_per_gc, rolloff = -30)
# one epoch, two subharmonics
rolloff_subh = soundgen:::getVocalFry(rolloff, pitch_per_gc,
  subFreq = 200, subDep = 150, shortestEpoch = 100)
# three epochs with 2/3/4 subharmonics
rolloff_subh = soundgen:::getVocalFry(rolloff, pitch_per_gc,
  subFreq = 200, subDep = 150, shortestEpoch = 0)
}
\keyword{internal}
