% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{.segment}
\alias{.segment}
\title{Internal soundgen function}
\usage{
.segment(
  audio,
  shortestSyl = 40,
  shortestPause = 40,
  method = c("env", "spec", "mel")[3],
  propNoise = NULL,
  SNR = NULL,
  noiseLevelStabWeight = c(1, 0.25),
  windowLength = 40,
  step = NULL,
  overlap = 80,
  reverbPars = list(reverbDelay = 70, reverbSpread = 130, reverbLevel = -35,
    reverbDensity = 50),
  interburst = NULL,
  peakToTrough = SNR + 3,
  troughLocation = c("left", "right", "both", "either")[4],
  maxDur = 30,
  saveAudio = NULL,
  addSilence = 50,
  plot = FALSE,
  plotname = "",
  savePlots = NULL,
  main = NULL,
  xlab = "",
  ylab = "Signal, dB",
  showLegend = FALSE,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  maxPoints = c(1e+05, 5e+05),
  specPlot = NULL,
  contourPlot = list(lty = 1, lwd = 2, col = "green"),
  sylPlot = list(lty = 1, lwd = 2, col = "blue"),
  burstPlot = list(pch = 8, cex = 3, col = "red"),
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{shortestSyl}{minimum acceptable length of syllables, ms}

\item{shortestPause}{minimum acceptable break between syllables, ms
(syllables separated by shorter pauses are merged)}

\item{method}{the signal used to search for syllables: 'env' =
Hilbert-transformed amplitude envelope, 'spec' = spectrogram, 'mel' =
mel-transformed spectrogram (see tuneR::melfcc)}

\item{propNoise}{the proportion of non-zero sound assumed to represent
background noise (note that complete silence is not considered, so padding
with silence won't affect the algorithm)}

\item{SNR}{expected signal-to-noise ratio (dB above noise), which determines
the threshold for syllable detection. The meaning of "dB" here is
approximate since the "signal" may be different from sound intensity}

\item{noiseLevelStabWeight}{a vector of length 2 specifying the relative
weights of the overall signal level vs. stability when attempting to
automatically locate the regions that represent noise. Increasing the
weight of stability tends to accentuate the beginning and end of each
syllable.}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{reverbPars}{parameters passed on to \code{\link{reverb}} to attempt to
cancel the effects of reverberation or echo, which otherwise tend to merge
short and loud segments like rapid barks}

\item{interburst}{minimum time between two consecutive bursts (ms). Defaults
to the average detected \code{(syllable + pause) / 2}}

\item{peakToTrough}{to qualify as a burst, a local maximum has to be at least
\code{peakToTrough} dB above the left and/or right local trough(s)
(controlled by \code{troughLocation}) over the analysis window (controlled
by \code{interburst}). Defaults to SNR + 3 dB}

\item{troughLocation}{should local maxima be compared to the trough on the
left and/or right of it? Values: 'left', 'right', 'both', 'either'}

\item{maxDur}{long files are split into chunks \code{maxDur} s in duration to
avoid running out of RAM; the outputs for all fragments are glued together,
but plotting is switched off. Note that noise profile is estimated in each
chunk separately, so set it low if the background noise is highly variable}

\item{saveAudio}{full path to the folder in which to save audio files (one
per detected syllable)}

\item{addSilence}{if syllables are saved as separate audio files, they can be
padded with some silence (ms)}

\item{plot}{if TRUE, produces a segmentation plot}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{xlab, ylab, main}{main plotting parameters}

\item{showLegend}{if TRUE, shows a legend for thresholds}

\item{width, height, units, res}{parameters passed to
\code{\link[grDevices]{png}} if the plot is saved}

\item{maxPoints}{the maximum number of "pixels" in the oscillogram (if any)
and spectrogram; good for quickly plotting long audio files; defaults to
c(1e5, 5e5)}

\item{specPlot}{a list of graphical parameters for displaying the spectrogram
(if \code{method = 'spec' or 'mel'}); set to NULL to hide the spectrogram}

\item{contourPlot}{a list of graphical parameters for displaying the signal
contour used to detect syllables (see details)}

\item{sylPlot}{a list of graphical parameters for displaying the syllables}

\item{burstPlot}{a list of graphical parameters for displaying the bursts}

\item{...}{other graphical parameters passed to graphics::plot}
}
\description{
A helper function called internally by segment() for segmenting a single sound.
}
\keyword{internal}
