% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{filled.contour.mod}
\alias{filled.contour.mod}
\title{Modified filled.contour}
\usage{
filled.contour.mod(
  x = seq(0, 1, len = nrow(z)),
  y = seq(0, 1, len = ncol(z)),
  z,
  xlim = range(x, finite = TRUE),
  ylim = range(y, finite = TRUE),
  zlim = range(z, finite = TRUE),
  levels = pretty(zlim, nlevels),
  nlevels = 30,
  color.palette = function(n) grDevices::hcl.colors(n, "YlOrRd", rev = TRUE),
  col = color.palette(length(levels) - 1),
  asp = NA,
  xaxs = "i",
  yaxs = "i",
  log = "",
  yScale = c("orig", "bark", "mel", "ERB")[1],
  axisX = TRUE,
  axisY = TRUE,
  maxPoints = 5e+05,
  ...
)
}
\arguments{
\item{x, y}{locations of grid lines (NB: x = time, y = frequency in kHz, not Hz!)}

\item{z}{numeric matrix of values to plot}

\item{xlim, ylim, zlim}{limits for the plot}

\item{levels}{levels for partitioning z}

\item{nlevels}{numbers of levels for partitioning z}

\item{color.palette}{color palette function}

\item{col}{list of colors instead of color.palette}

\item{asp, xaxs, yaxs, ...}{graphical parameters passed to plot.window() and
axis()}

\item{log}{log = 'y' log-transforms the y axis}

\item{axisX, axisY}{plot the axis or not (logical)}
}
\description{
Internal soundgen function
}
\details{
A bare-bones version of \code{\link[graphics]{filled.contour}} that does not
plot a legend and accepts some additional graphical parameters like tick
marks.
}
\keyword{internal}
