% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectNLP.R
\name{detectPitchJumps}
\alias{detectPitchJumps}
\title{Detect pitch jumps}
\usage{
detectPitchJumps(pitch, step, jumpThres, jumpWindow)
}
\arguments{
\item{pitch}{vector of pitch values per frame, Hz}

\item{step}{time step between pitch values, ms}

\item{jumpThres}{frames in which pitch changes by \code{jumpThres} octaves/s
more than in the surrounding frames are classified as containing "pitch
jumps"}

\item{jumpWindow}{the window for calculating the median pitch slope around
the analyzed frame, ms}
}
\description{
Interal soundgen function
}
\examples{
pitch = getSmoothContour(anchors = list(
  time = c(0, 350, 351, 890, 891, 1200),
  value = c(140, 230, 460, 330, 220, 200)), len = 40)
soundgen:::detectPitchJumps(pitch, step = 25,
  jumpThres = 10, jumpWindow = 100)
}
\keyword{internal}
