% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchTrackers.R
\name{getPitchCep}
\alias{getPitchCep}
\title{Cepstral pitch tracker}
\usage{
getPitchCep(
  frame,
  samplingRate,
  bin,
  nCands,
  cepThres,
  cepZp,
  pitchFloor,
  pitchCeiling,
  tol = 0.05,
  specMerge = 2/12
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{samplingRate}{sampling rate (Hz)}

\item{bin}{spectrogram bin width, Hz}

\item{nCands}{maximum number of pitch candidates per method, normally 1...4
(except for \code{dom}, which returns at most one candidate per frame)}

\item{cepThres}{voicing threshold (unitless, ~0 to 1)}

\item{cepZp}{zero-padding of the spectrum used for cepstral pitch detection
(final length of spectrum after zero-padding in points, e.g. 2 ^ 13)}

\item{pitchFloor, pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{tol}{tolerance when removing false subharmonics}

\item{specMerge}{tolerance when removing similar candidates, oct}
}
\value{
Returns either NULL or a dataframe of pitch candidates and CPP.
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by looking for peaks in the cepstrum.
See http://www.phon.ucl.ac.uk/courses/spsci/matlab/lect10.html
}
\keyword{internal}
