% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum_utilities.R
\name{msToSpec}
\alias{msToSpec}
\title{Modulation spectrum to spectrogram}
\usage{
msToSpec(ms, windowLength = NULL, step = NULL)
}
\arguments{
\item{ms}{target modulation spectrum (matrix of complex numbers)}

\item{windowLength}{length of FFT window, ms (multiple values in a vector
produce a multi-resolution spectrogram)}

\item{step}{you can override \code{overlap} by specifying FFT step, ms - a
vector of the same length as windowLength (NB: because digital audio is
sampled at discrete time intervals of 1/samplingRate, the actual step and
thus the time stamps of STFT frames may be slightly different, eg 24.98866
instead of 25.0 ms)}
}
\value{
Returns a spectrogram - a numeric matrix of complex numbers of
  the same dimensions as ms.
}
\description{
Takes a complex MS and transforms it to a complex spectrogram with proper row
(frequency) and column (time) labels.
}
\examples{
s = soundgen(sylLen = 250, amFreq = 25, amDep = 50,
             pitch = 250, samplingRate = 16000)
spec = spectrogram(s, samplingRate = 16000, windowLength = 25, step = 5)
ms = specToMS(spec)
plotMS(log(Mod(ms)), quantiles = NULL, col = soundgen:::jet.col(100))
spec_new = msToSpec(ms)
spectrogram(s, specManual = Mod(spec_new))
\dontrun{
# or plot manually
image(x = as.numeric(colnames(spec_new)), y = as.numeric(rownames(spec_new)),
      z = t(log(abs(spec_new))), xlab = 'Time, ms',
      ylab = 'Frequency, kHz')
}
}
