% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spTukey.R
\name{spTukey}
\alias{spTukey}
\alias{spTukey.SARanova}
\alias{spTukey.GEOanova}
\title{Compute Tukey Honest Significant Differences for a Spatially Correlated Model}
\usage{
spTukey(x, sig.level = 0.05)

\method{spTukey}{SARanova}(x, sig.level = 0.05)

\method{spTukey}{GEOanova}(x, sig.level = 0.05)
}
\arguments{
\item{x}{A fitted model object of class SARcrd, SARrcbd or GEOanova.}

\item{sig.level}{A numeric value between zero and one giving the significance
level to use.}
}
\value{
a data frame containing the original mean, the spatially filtered mean and its group.
For the class GEOanova, the spatial dependence is filtered out using geostatistics,
while for the class SARanova the adjusted response based on SAR model is employed.
}
\description{
Perform multiple comparisons of means treatments based on the Studentized range
statistic when the errors are spatially correlated.
}
\details{
For objects of class SARcrd or SARrcbd this function performs the standard
Tukey's ‘Honest Significant Difference’ method provided by the function
\code{\link[stats]{TukeyHSD}} on the adjusted response.

For objects of class GEOanova, the method is modified to take into account
the spatial dependence among the observations. First, we estimate a
contrast matrix (\eqn{C}) using cont.tuk function and then after estimate the
spatial mean of each treatment (\eqn{\mu_i}) we can assess the significance of
the contrast by

\deqn{|c_i \mu_i| > {HSD}_i}

where \eqn{HSD_i = q(\alpha, k, \nu) * sqrt(0.5*{w}_ii)} and
\eqn{k} is the number of treatments, \eqn{\alpha} is the level of significance,
\eqn{\nu} is the degree of freedom of the model, \eqn{{w}_ii} is the variance of
the i-th contrast.
}
\examples{
data("crd_simulated")

#Geodata object
geodados <- as.geodata(crd_simulated, coords.col = 1:2, data.col = 3,
                      covar.col = 4)
h_max <- summary(geodados)[[3]][[2]]
dist <- 0.6*h_max

# Computing the variogram
variograma <- spVariog(geodata = geodados,
                      trend = "cte", max.dist = dist, design = "crd",
                      scale = FALSE)

plot(variograma, ylab = "Semivariance", xlab = "Distance")

# Gaussian Model
ols <- spVariofit(variograma, cov.model = "gaussian", weights = "equal",
                 max.dist = dist)

lines(ols, col = 1)

# Compute the model and get the analysis of variance table
mod <- aovGeo(ols, cutoff = 0.6)

# Tukey's HSD
spTukey(mod)


}
\references{
Nogueira, C. H. Testes para comparações múltiplas de
médias em experimentos com tendência e dependência espacial.
142 f. Tese (Doutorado em Estatística e Experimentação
Agropecuária) | Universidade Federal de Lavras, Lavras, 2017
}
