% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aovSar.rcbd.R
\name{aovSar.rcbd}
\alias{aovSar.rcbd}
\title{Using a SAR model to handle spatial dependence in a Randomized Complete Block Design}
\usage{
aovSar.rcbd(resp, treat, block, coord, seq.radius)
}
\arguments{
\item{resp}{Numeric or complex vector containing the values of response variable.}

\item{treat}{Numeric or complex vector containing the treatment applied to each experimental unit.}

\item{block}{Numeric or complex vector specifying the blocks.}

\item{coord}{Matrix of point coordinates or a SpatialPoints Object.}

\item{seq.radius}{Complex vector containing a radii sequence used to set the neighborhood pattern.
The default sequence has ten numbers from 0 to half of the maximum distance between the samples.}
}
\value{
\code{aovSar.rcbd} returns an object of \code{\link[base]{class}} "SARanova".
The functions summary and anova are used to obtain and print a summary and analysis of variance
table of the results.
An object of class "SARanova" is a list containing the following components:

\item{DF}{degrees of freedom of rho, treatments, residual and total.}
\item{SS}{sum of squares of rho, treatments and residual.}
\item{Fc}{F statistic calculated for treatment.}
\item{residuals}{residuals of the adjusted model.}
\item{p.value}{p-value associated to F statistic for treatment.}
\item{rho}{the autoregressive parameter.}
\item{Par}{data.frame with the radii tested and its AIC.}
\item{y_orig}{vector of response.}
\item{y_ajus}{vector of adjusted response.}
\item{treat}{vector of treatment applied to each experimental unit.}
\item{modelAdj}{model of class \code{\link[stats]{aov}} using the adjusted response.}
\item{modelstd}{data frame containing the ANOVA table using non-adjusted response.}
\item{namey}{response variable name.}
\item{namex}{treatment variable name.}
}
\description{
Fit a randomized complete block design when the experimental units have some degree of
spatial dependence using a Spatial Lag Model (SAR).
}
\details{
Three assumptions are made about the error in the analysis of variance (ANOVA):

1. the errors are normally distributed and, on average, zero;

2. the errors all have the same variance (they are homoscedastic), and

3. the errors are unrelated to each other (they are independent across observations).

When these assumptions are not satisfied, data transformations in the response variable are
often used to circumvent this problem. For example, in absence of normality, the Box-Cox
transformation can be used.

However, in many experiments, especially field trials, there is a type of correlation generated by
the sample locations known as spatial correlation, and this condition violates the independence assumption.
In this setting, this function provides an alternative for using ANOVA when the errors are spatially
correlated, by using a data transformation discussed in Long (1996)

\deqn{Y_{adj} = Y - (\hat{\rho}WY - \hat{\rho}\beta_0),}

where \eqn{\hat{\rho}} denotes the autoregressive spatial parameter of the SAR model estimated by
lagsarlm, \eqn{\beta_0} is the overall mean and \eqn{W} is a spatial neighborhood matrix which neighbors are defined as the
samples located within a radius, this radius is specified as a sequence in \code{seq.radius}. For each radius
in \code{seq.radius} the model is computed as well its AIC, then the radius chosen is the one
that minimizes AIC.

The aim of this transformation is converting autocorrelated observations into non-correlated observations
in order to apply the analysis of variance and obtain suitable inferences.
}
\examples{
data("rcbd_simulated")

# Fitting the model
model <- aovSar.rcbd(rcbd_simulated$y, rcbd_simulated$trat, rcbd_simulated$block,
                     cbind(rcbd_simulated$coordX, rcbd_simulated$coordY))

# Summary for class SARanova
summary(model)

# Anova for class SARanova
anova(model)

}
\references{
Long, D.S., 1996. Spatial statistics for analysis of variance of agronomic field trials. In:
Arlinghaus, S.L. (Ed.), Practical Handbook of Spatial Statistics. CRC Press, Boca Raton, FL,
pp. 251–278.

Rossoni, D. F.; Lima, R. R. . Autoregressive analysis of variance for experiments with spatial
dependence between plots: a simulation study. Revista Brasileira de Biometria, 2019

Scolforo, Henrique Ferraço, et al. "Autoregressive spatial analysis and individual
tree modeling as strategies for the management of Eremanthus erythropappus." Journal of
forestry research 27.3 (2016): 595-603.
}
