% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm.R
\name{slm}
\alias{slm}
\alias{slm,sf-method}
\alias{slm,SpatRaster-method}
\title{spatial logistic map}
\usage{
\S4method{slm}{sf}(
  data,
  x = NULL,
  y = NULL,
  z = NULL,
  k = 4,
  step = 15,
  alpha_x = 0.28,
  alpha_y = 0.25,
  alpha_z = 0.22,
  beta_xy = 0.05,
  beta_xz = 0.05,
  beta_yx = 0.2,
  beta_yz = 0.2,
  beta_zx = 0.35,
  beta_zy = 0.35,
  threshold = Inf,
  transient = 1,
  interact = "local",
  nb = NULL
)

\S4method{slm}{SpatRaster}(
  data,
  x = NULL,
  y = NULL,
  z = NULL,
  k = 4,
  step = 15,
  alpha_x = 0.28,
  alpha_y = 0.25,
  alpha_z = 0.22,
  beta_xy = 0.05,
  beta_xz = 0.05,
  beta_yx = 0.2,
  beta_yz = 0.2,
  beta_zx = 0.35,
  beta_zy = 0.35,
  threshold = Inf,
  transient = 1,
  interact = "local"
)
}
\arguments{
\item{data}{observation data.}

\item{x}{(optional) name of first spatial variable.}

\item{y}{(optional) name of second spatial variable.}

\item{z}{(optional) name of third spatial variable.}

\item{k}{(optional) number of neighbors to used.}

\item{step}{(optional) number of simulation time steps.}

\item{alpha_x}{(optional) growth parameter for x.}

\item{alpha_y}{(optional) growth parameter for y.}

\item{alpha_z}{(optional) growth parameter for y.}

\item{beta_xy}{(optional) cross-inhibition from x to y.}

\item{beta_xz}{(optional) cross-inhibition from x to z.}

\item{beta_yx}{(optional) cross-inhibition from y to x.}

\item{beta_yz}{(optional) cross-inhibition from y to z.}

\item{beta_zx}{(optional) cross-inhibition from z to x.}

\item{beta_zy}{(optional) cross-inhibition from z to y.}

\item{threshold}{(optional) set to \code{NaN} if the absolute value exceeds this threshold.}

\item{transient}{(optional) transients to be excluded from the results.}

\item{interact}{(optional) type of cross-variable interaction (\code{local} or \code{neighbors}).}

\item{nb}{(optional) neighbours list.}
}
\value{
A list
}
\description{
spatial logistic map
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
columbus$inc = sdsfun::normalize_vector(columbus$inc)
slm(columbus,"inc")

}
\references{
Willeboordse, F.H., The spatial logistic map as a simple prototype for spatiotemporal chaos, Chaos, 533–540 (2003).
}
