% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_functions.R
\name{cross_kfunctions.mc}
\alias{cross_kfunctions.mc}
\title{Network cross k and g functions (multicore, experimental)}
\usage{
cross_kfunctions.mc(
  lines,
  pointsA,
  pointsB,
  start,
  end,
  step,
  width,
  nsim,
  conf_int = 0.05,
  digits = 2,
  tol = 0.1,
  agg = NULL,
  verbose = TRUE
)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame with the sampling points. The geometries
must be a SpatialLinesDataFrame (may crash if some geometries are invalid)}

\item{pointsA}{A SpatialPointsDataFrame representing the points to which the
distances are calculated.}

\item{pointsB}{A SpatialPointsDataFrame representing the points from which
the distances are calculated.}

\item{start}{A double, the start value for evaluating the k and g functions}

\item{end}{A double, the last value for evaluating the k and g functions}

\item{step}{A double, the jump between two evaluations of the k and g
function}

\item{width}{The width of each donut for the g-function}

\item{nsim}{An integer indicating the number of Monte Carlo simulations
required}

\item{conf_int}{A double indicating the width confidence interval (default =
0.05)}

\item{digits}{An integer indicating the number of digits to retain for the
spatial coordinates}

\item{tol}{When adding the points to the network, specify the minimum
distance between these points and the lines' extremities. When points are
closer, they are added at the extremity of the lines.}

\item{agg}{A double indicating if the events must be aggregated within a
distance. If NULL, the events are aggregated by rounding the coordinates.}

\item{verbose}{A Boolean indicating if progress messages should be displayed}
}
\value{
A list with the following values : \cr \itemize{ \item{plotk}{A
  ggplot2 object representing the values of the cross k-function}
  \item{plotg}{A ggplot2 object representing the values of the cross
  g-function} \item{values}{A DataFrame with the values used to build the
  plots} }
}
\description{
Calculate the cross k and g functions for a set of points on a
  network with multicore support. (experimental)
}
\examples{
\dontrun{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
main_network_mtl <- rgdal::readOGR(networkgpkg,layer="main_network_mtl", verbose=FALSE)
mtl_libraries <- rgdal::readOGR(eventsgpkg,layer="mtl_libraries", verbose=FALSE)
mtl_theatres <- rgdal::readOGR(eventsgpkg,layer="mtl_theatres", verbose=FALSE)
future::plan(future::multisession(workers=2))
result <- cross_kfunctions.mc(main_network_mtl, mtl_libraries, mtl_theatres,
                           start = 0, end = 2500, step = 10, width = 250,
                           nsim = 50, conf_int = 0.05, digits = 2,
                           tol = 0.1, agg = NULL, verbose = TRUE)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
