% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_functions.R
\name{lixelize_lines}
\alias{lixelize_lines}
\title{Cut lines into lixels}
\usage{
lixelize_lines(lines, lx_length, mindist = NULL, verbose = FALSE)
}
\arguments{
\item{lines}{The SpatialLinesDataframe to modify}

\item{lx_length}{The length of a lixel}

\item{mindist}{The minimum length of a lixel. After cut, if the length of the
final lixel is shorter than the minimum distance, then it is added to the
previous lixel. if NULL, then mindist = maxdist/10. Note that the segments
that are already shorter than the minimum distance are not modified.}

\item{verbose}{A Boolean indicating if a progress bar should be displayed}
}
\value{
An object of class SpatialLinesDataFrame (package sp)
}
\description{
Cut a SpatialLines object into lixels with a specified minimal
  distance may fail if the lines geometries are self intersecting.
}
\examples{
\dontrun{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
lixels <- lixelize_lines(mtl_network,150,50)
}
}
