% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_indexing.R
\name{closest_points}
\alias{closest_points}
\title{Find closest points}
\usage{
closest_points(origins, targets)
}
\arguments{
\item{origins}{a SpatialPointsDataFrame}

\item{targets}{a SpatialPointsDataFrame}
}
\value{
for each origin point, the index of the nearest target point
}
\description{
Solve the nearest neighbour problem for two SpatialPointsDataFrame.
This is a simple wrap-up of the FNN::knnx.index function
}
\examples{
#This is an internal function, no example provided
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_libraries <- rgdal::readOGR(eventsgpkg,layer="mtl_libraries", verbose=FALSE)
mtl_theatres <- rgdal::readOGR(eventsgpkg,layer="mtl_theatres", verbose=FALSE)
close_libs <- closest_points(mtl_theatres, mtl_libraries)
}
