% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{adaptive_bw_tnkde_cpp2}
\alias{adaptive_bw_tnkde_cpp2}
\title{The exposed function to calculate adaptive bandwidth with space-time
interaction for TNKDE (INTERNAL)}
\usage{
adaptive_bw_tnkde_cpp2(
  method,
  neighbour_list,
  sel_events,
  sel_events_wid,
  sel_events_time,
  events,
  events_wid,
  events_time,
  weights,
  bws_net,
  bws_time,
  kernel_name,
  line_list,
  max_depth,
  min_tol
)
}
\arguments{
\item{method}{a string, one of "simple", "continuous", "discontinuous"}

\item{neighbour_list}{a List, giving for each node an IntegerVector with
its neighbours}

\item{sel_events}{a Numeric vector indicating the selected events (id of nodes)}

\item{sel_events_wid}{a Numeric Vector indicating the unique if of the selected events}

\item{sel_events_time}{a Numeric Vector indicating the time of the selected events}

\item{events}{a NumericVector indicating the nodes in the graph being events}

\item{events_wid}{a NumericVector indicating the unique id of all the events}

\item{events_time}{a NumericVector indicating the timestamp of each event}

\item{weights}{a cube with the weights associated with each event for each
bws_net and bws_time.}

\item{bws_net}{an arma::vec with the network bandwidths to consider}

\item{bws_time}{an arma::vec with the time bandwidths to consider}

\item{kernel_name}{a string with the name of the kernel to use}

\item{line_list}{a DataFrame describing the lines}

\item{max_depth}{the maximum recursion depth}

\item{min_tol}{a double indicating by how much 0 in density values must be replaced}
}
\value{
a vector with the estimated density at each event location
}
\description{
The exposed function to calculate adaptive bandwidth with space-time
interaction for TNKDE (INTERNAL)
}
\examples{
# no example provided, this is an internal function
}
