% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image_overlay.R
\name{load_overlay}
\alias{load_overlay}
\title{Import PNG textures for overlays}
\usage{
load_overlay(filename)
}
\arguments{
\item{filename}{The path to the PNG file to be imported}
}
\value{
A matrix of values provided by \code{\link[png]{readPNG}}
}
\description{
This is an extremely thin wrapper for \code{\link[png]{readPNG}}, in order
for users to not realize they even needed \code{png} for this package's
functionality at all.
}
\examples{
\dontrun{
bbox <- get_centroid_bounding_box(c(
  "lat" = 44.121268,
  "lng" = -73.903734
),
distance = 10
)

overlay_file <- tempfile("overlay_file", fileext = ".png")
get_image_overlay(bbox,
  save.png = TRUE,
  png.filename = overlay_file,
  overlay = "World_Imagery"
)
overlay <- load_overlay(overlay_file)
}

}
