% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{spod_multi_download_with_progress}
\alias{spod_multi_download_with_progress}
\title{Download multiple files with progress bar sequentially}
\usage{
spod_multi_download_with_progress(
  files_to_download,
  chunk_size = 1024 * 1024,
  bar_width = 20,
  show_progress = interactive() && !isTRUE(getOption("knitr.in.progress"))
)
}
\arguments{
\item{files_to_download}{A data frame with columns \code{target_url}, \code{local_path} and \code{file_size_bytes}.}

\item{chunk_size}{Number of bytes to download at a time.}

\item{bar_width}{Width of the progress bar.}

\item{show_progress}{Whether to show the progress bar.}
}
\value{
A data frame with columns \code{target_url}, \code{local_path}, \code{file_size_bytes} and \code{local_file_size}.
}
\description{
Download multiple files with a progress bar. Retries failed downloads up to 3 times.
}
\keyword{internal}
