% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spareg.R
\name{get_model}
\alias{get_model}
\title{Extractor of model from a '\code{spar}' or '\code{spar.cv}' object}
\usage{
get_model(object, opt_par = c("best", "1se"))
}
\arguments{
\item{object}{A fitted '\code{spar}' or '\code{spar.cv}'  model}

\item{opt_par}{One of "best", "1se"}
}
\value{
A '\code{spar}'  or '\code{spar.cv}'  object where the beta and intercept elements are
the ones which correspond to the best or the 1se model.
}
\description{
Extractor of model from a '\code{spar}' or '\code{spar.cv}' object
}
\examples{
example_data <- simulate_spareg_data(n = 100, p = 400, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30))
best_model <- get_model(spar_res, opt_par = "best")
\donttest{
spar_cv <- spar.cv(example_data$x, example_data$y,
  nummods = c(5, 10, 15, 20, 25, 30), nfolds = 4)
best_model_cv <- get_model(spar_cv, opt_par = "best")
onese_model_cv <- get_model(spar_cv, opt_par = "1se")
}
}
