% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_interface.R
\name{ml_model}
\alias{ml_model}
\title{Create an ML Model Object}
\usage{
ml_model(class, model, ..., .call = sys.call(sys.parent()))
}
\arguments{
\item{class}{The name of the machine learning routine used in the
encompassing model. Note that the model name generated will be
generated as \code{ml_model_<class>}; that is, \code{ml_model}
will be prefixed.}

\item{model}{The underlying Spark model object.}

\item{...}{Additional model information; typically supplied as named
values.}

\item{.call}{The \R call used in generating this model object (ie,
the top-level \R routine that wraps over the associated Spark ML
routine). Typically used for print output in e.g. \code{print}
and \code{summary} methods.}
}
\description{
Create an ML model object, wrapping the result of a Spark ML routine call.
The generated object will be an \R list with S3 classes
\code{c("ml_model_<class>", "ml_model")}.
}
