% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_wrapper.R
\name{sdf_collect}
\alias{sdf_collect}
\title{Collect a Spark DataFrame into R.}
\usage{
sdf_collect(object, impl = c("row-wise", "row-wise-iter", "column-wise"), ...)
}
\arguments{
\item{object}{Spark dataframe to collect}

\item{impl}{Which implementation to use while collecting Spark dataframe
- row-wise: fetch the entire dataframe into memory and then process it row-by-row
- row-wise-iter: iterate through the dataframe using RDD local iterator, processing one row at
                 a time (hence reducing memory footprint)
- column-wise: fetch the entire dataframe into memory and then process it column-by-column
NOTE: (1) this will not apply to streaming or arrow use cases (2) this parameter will only affect
implementation detail, and will not affect result of `sdf_collect`, and should only be set if
performance profiling indicates any particular choice will be significantly better than the default
choice ("row-wise")}

\item{...}{Additional options.}
}
\description{
Collects a Spark dataframe into R.
}
