% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-inference.R
\name{fit_multinom_dag}
\alias{fit_multinom_dag}
\title{Inference in discrete Bayesian networks}
\usage{
fit_multinom_dag(parents, dat)
}
\arguments{
\item{parents}{An \code{\link{edgeList}} object.}

\item{dat}{Data, a dataframe or matrix}
}
\value{
A list with with one component for each node in the graph.
Each node is a coefficient matrix for the parents of that node.
}
\description{
Given the structure of a Bayesian network, estimate the parameters
using multinomial logistic regression. For each node \eqn{i}, regress
\eqn{i} onto its parents set using \code{\link[nnet]{multinom}}
in package \code{\link{nnet}}.
}
\examples{

\dontrun{
### construct a random data set
x <- c(0,1,0,1,0)
y <- c(1,0,1,0,1)
z <- c(0,1,2,1,0)
a <- c(1,1,1,0,0)
b <- c(0,0,1,1,1)
dat <- data.frame(x, y, z, a, b)

### randomly construct an edgelist of a graph
nnode <- ncol(dat)
li <- vector("list", length = nnode)
li[[1]] <- c(2L,4L)
li[[2]] <- c(3L,4L,5L)
li[[3]] <- integer(0)
li[[4]] <- integer(0)
li[[5]] <- integer(0)
edgeL <- edgeList(li)

### run fit_multinom_dag
fit.multinom <- fit_multinom_dag(edgeL, dat)
}

}

