% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.sparsegl-methods.R
\name{coef.cv.sparsegl}
\alias{coef.cv.sparsegl}
\title{Get coefficients from a \code{cv.sparsegl} object.}
\usage{
\method{coef}{cv.sparsegl}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted \code{\link[=cv.sparsegl]{cv.sparsegl()}} object.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
coefficients are desired. Default is the single
value \code{s = "lambda.1se"} stored on the CV \code{object} (corresponding to
the largest value of \code{lambda} such that CV error estimate is within 1
standard error of the minimum). Alternatively \code{s = "lambda.min"} can be
used (corresponding to the minimum of cross validation error estimate).
If \code{s} is numeric, it is taken as the value(s) of \code{lambda} to be used.}

\item{...}{Not used. Other arguments to \code{\link[=predict]{predict()}}.}
}
\value{
The coefficients at the requested value(s) for \code{lambda}.
}
\description{
This function gets coefficients from a
cross-validated \code{\link[=sparsegl]{sparsegl()}} model, using the stored \code{"sparsegl.fit"}
object, and the optimal value chosen for \code{lambda}.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
fit1 <- sparsegl(X, y, group = groups)
cv_fit <- cv.sparsegl(X, y, groups)
coef(cv_fit, s = c(0.02, 0.03))
}
\seealso{
\code{\link[=cv.sparsegl]{cv.sparsegl()}}, and \code{\link[=predict.cv.sparsegl]{predict.cv.sparsegl()}} methods.
}
