% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse_sqrt.R
\name{sparse_sqrt}
\alias{sparse_sqrt}
\title{Calculate sqrt of sparse vectors}
\usage{
sparse_sqrt(x)
}
\arguments{
\item{x}{A sparse numeric vector.}
}
\value{
A sparse double vector.
}
\description{
Calculate sqrt of sparse vectors
}
\details{
This function, as with any of the other helper functions assumes that the
input \code{x} is a sparse numeric vector. This is done for performance reasons,
and it is thus the users responsibility to perform input checking.

The output will be a double vector regardless of the input type.
}
\examples{
sparse_sqrt(
  sparse_double(1000, 1, 10)
)

sparse_sqrt(
  sparse_integer(1000, 3, 10, default = 2)
)

sparse_sqrt(
  sparse_double(c(10, NA, 11), c(1, 5, 10), 10)
)
}
