efast_run_Analysis <-
function(FILEPATH,MEASURES,PARAMETERS,NUMCURVES,NUMSAMPLES,OUTPUTMEASURES_TO_TTEST,TTEST_CONF_INT,GRAPH_FLAG,CURVERESULTSFILENAME,EFASTRESULTFILENAME,TIMEPOINT,TIMEPOINTSCALE)
{
	if(file.exists(FILEPATH))
	{
		#CURVERESULTSFILENAME IS AllResults.csv FOR 1 TIMEPOINT
		#EFASTRESULTFILENAME IS eFAST_Analysis.csv FOR 1 TIMEPOINT

		NUMPARAMS<-length(PARAMETERS) # of input factors (parameters varied)
		
		NUMOUTMEASURES<-length(MEASURES)
	
		# maximum number of fourier coefficients
		# that may be retained in calculating the partial
		# variances without interferences between the
		# assigned frequencies
		MI<-4  
		wantedN<-NUMSAMPLES*NUMPARAMS*NUMCURVES # wanted no. of sample points
		OMi<-floor(((wantedN/NUMCURVES)-1)/(2*MI)/NUMPARAMS)
	
		# RUNS HAVE BEEN DONE OUTSIDE OF R USING THE PARAMETER SETS GENERATED BY EFAST
		# READ IN THE MEDIAN RESULT SETS
	
		print("Producing eFAST Analysis (efast_run_analysis)")

		# READ IN THE FIRST CURVE
		if(file.exists(paste(FILEPATH,"/",1,"/",CURVERESULTSFILENAME,sep="")))
		{
			RESULTS<-read.csv(paste(FILEPATH,"/",1,"/",CURVERESULTSFILENAME,sep=""),sep=",")

			# NOW READ IN ANY FURTHER CURVES
			if(NUMCURVES>1)
			{
				for(CURVE in 2:NUMCURVES)
				{
					if(file.exists(paste(FILEPATH,"/",CURVE,"/",CURVERESULTSFILENAME,sep="")))
					{
						CURVERESULTS<-read.csv(paste(FILEPATH,"/",CURVE,"/",CURVERESULTSFILENAME,sep=""),sep=",")
						# NOTE THIS ASSUMES THAT THE RESULTS HAVE BEEN GENERATED WITH THE FIRST COLUMN CONTAINING NO SAMPLE COUNT
						# ADD TO THE PREVIOUS CURVES
						RESULTS<-cbind(RESULTS,CURVERESULTS[1:length(CURVERESULTS)])
					}
					else
					{
						print(paste("No summary file for Curve ",CURVE,". Are you sure you have run the method to generate it?",sep=""))
					}	
					
				}
			}
	
			# CONVERT THE RESULTS FILE FOR EASE OF PROCESSING LATER
			RESULTS<-as.matrix(RESULTS)
			# PUT IN MULTI DIMENSIONAL ARRAY
			# EACH DIMENSION CONTAINS ONE CURVE
			RESULTSARRAY<-array(RESULTS,dim=c(NUMSAMPLES,(NUMPARAMS*NUMOUTMEASURES),NUMCURVES))
		
			# NOW GENERATE THE SENSITIVITY INDEXES
			# efast_sd IS WITHIN efast_sd.R
			print("Generating Sensitivity Indexes")
			resultList<-efast_sd(RESULTSARRAY,OMi,MI,NUMOUTMEASURES,NUMPARAMS,NUMCURVES)
		
			# GET THE COEFFICIENTS OF VARIANCE
			cvSi_coeffResults<-NULL
			cvSTi_coeffResults<-NULL
			errorsSi<-NULL
			errorsSTi<-NULL
	
			for(OUTPUTMEASURE in 1:NUMOUTMEASURES)
			{
				# efast_cvmethod is within CVmethod.R
				outputMeasureCVs <- efast_cvmethod(resultList$Si, resultList$rangeSi,resultList$STi,resultList$rangeSTi,OUTPUTMEASURE,NUMPARAMS,NUMCURVES,NUMOUTMEASURES)
				cvSi_coeffResults <- rbind(cvSi_coeffResults,outputMeasureCVs$CVSi)
				cvSTi_coeffResults <- rbind(cvSTi_coeffResults,outputMeasureCVs$CVSTi)
				errorsSi <- cbind(errorsSi,outputMeasureCVs$errorSi)
				errorsSTi <- cbind(errorsSTi,outputMeasureCVs$errorSTi)
			}
	
			# TRANSPOSE SO THAT THE OUTPUT ORDERING IS IN THE SAME FORMAT AS THE REST OF THE RESULTS (MEASURES ARE COLUMNS, PARAMETERS ARE ROWS)
			cvSi_coeffResults<-t(cvSi_coeffResults)
			cvSTi_coeffResults<-t(cvSTi_coeffResults)
		
			# NOW DO THE T-TEST TO GET THE P-VALUES AGAINST THE DUMMY PARAMETER
			# efast_ttest IS WITHIN efast_ttest.R
		
			print("Generating measures of statistical significance")
			t_tests <- efast_ttest(resultList$Si,resultList$rangeSi,resultList$STi,resultList$rangeSTi,OUTPUTMEASURES_TO_TTEST,NUMPARAMS,NUMCURVES,TTEST_CONF_INT)
		
			# NOW GET THE OUTPUT IN A FORMAT WHICH CAN BE OUTPUT TO AN EASILY READABLE CSV FILE
		
			formattedResults<-NULL
			for(MEASURE in seq(OUTPUTMEASURES_TO_TTEST))
			{
				# OUTPUT FORMAT
				# COLUMNS ORDERED BY MEASURE
				# 5 COLUMNS PER MEASURE - (i) Si (ii) Si P Val (iii) STi (iv) STi P Val (v) SCi
		
				measureResults<-cbind(resultList$Si[,,MEASURE],t_tests$p_Si[,,MEASURE],resultList$STi[,,MEASURE],t_tests$p_STi[,,MEASURE],(1-resultList$STi[,,MEASURE]),cvSi_coeffResults[,MEASURE],cvSTi_coeffResults[,MEASURE],errorsSi[,MEASURE],errorsSTi[,MEASURE])

		colnames(measureResults)<-c(paste(MEASURES[MEASURE],"_Si",sep=""),paste(MEASURES[MEASURE],"_Si_PVal",sep=""),paste(MEASURES[MEASURE],"_STi",sep=""),paste(MEASURES[MEASURE],"_STi_PVal",sep=""),paste(MEASURES[MEASURE],"_SCi",sep=""),paste(MEASURES[MEASURE],"_Si_CoEff_of_Var",sep=""),paste(MEASURES[MEASURE],"_STi_CoEff_of_Var",sep=""),paste(MEASURES[MEASURE],"_Si_ErrorBar",sep=""),paste(MEASURES[MEASURE],"_STi_ErrorBar",sep=""))

				formattedResults<-cbind(formattedResults,measureResults)
			}

			rownames(formattedResults)<-c(PARAMETERS)

			# OUTPUT THE SUMMARY RESULTS FILES
			# A - THE FILE WITH THE AMOUNT OF VARIANCE ACCOUNTED FOR BY EACH PARAMETER
			resultsFile = paste(FILEPATH,"/",EFASTRESULTFILENAME,sep="")
			write.csv(formattedResults,resultsFile,quote = FALSE)

			print(paste("eFAST Results file generated. Output to ",resultsFile,sep=""))
		
			# GRAPH THE RESULTS IF REQUIRED
			if(GRAPH_FLAG)
			{
				print("Graphing Results")
				efast_graph_Results(FILEPATH,PARAMETERS,resultList$Si,resultList$STi,errorsSi,errorsSTi,MEASURES,TIMEPOINT,TIMEPOINTSCALE)
			}
		}
		else
		{
			print("No summary file for Curve 1. Are you sure you have run the method to generate it?")
		}
	}
	else
	{
		print("The directory specified in FILEPATH does not exist. No eFAST Graphs Created")
	}	
}

