% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis_netlogo.R
\name{efast_process_netlogo_result}
\alias{efast_process_netlogo_result}
\title{Analyses Netlogo simulation data for parameter sets generated for eFAST}
\usage{
efast_process_netlogo_result(FILEPATH, EFASTSAMPLE_RESULTFILENAME, PARAMETERS,
  NUMCURVES, NUMSAMPLES, MEASURES, RESULTFILENAME, TIMESTEP)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs can be found}

\item{EFASTSAMPLE_RESULTFILENAME}{Name of the result file generated by
Netlogo, for an eFAST parameter sample.}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMCURVES}{The number of 'resamples' to perform
(see eFAST documentation) - recommend using at least 3.}

\item{NUMSAMPLES}{The number of parameter subsets that were generated
from each curve in the eFAST design}

\item{MEASURES}{Array containing the names of the Netlogo output measures
which are used to analyse the simulation.}

\item{RESULTFILENAME}{Name of the result file that will be produced which
summarises all results}

\item{TIMESTEP}{Timestep of the Netlogo simulation being analysed.}
}
\description{
Takes each parameter value set generated by eFAST in turn, and analyses the
Netlogo simulation results.  For each parameter set, there will be n
simulation results. This method goes through these results, producing
a file containing the median of each output measure for each of the n runs.
Thus, if a Netlogo simulation was replicated 10 times, the median file will
contain 10 medians for each simulation output measure. The user should then
run  \code{efast_get_overall_medians} and
\code{efast_run_Analysis} to analyse the results
}
