% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_analysis.R
\name{generate_medians_for_param_set}
\alias{generate_medians_for_param_set}
\title{Generate the median responses for a set of parameter values}
\usage{
generate_medians_for_param_set(SAMPLEFILEPATH, NUMRUNSPERSAMPLE, MEASURES,
  RESULTFILENAME, ALTERNATIVEFILENAME, OUTPUTCOLSTART, OUTPUTCOLEND, EXP_PARAMS,
  PARAMETER, PARAM_VAL)
}
\arguments{
\item{SAMPLEFILEPATH}{Path to the results currently being analysed (parameter and value)}

\item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter subset. This figure is generated through Aleatory Analysis}

\item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}

\item{RESULTFILENAME}{Name of the simulation results file. In the current version, XML and CSV files can be processed. If performing this analysis over multiple timepoints, it is assumed that the timepoint follows the file name, e.g. trackedCells_Close_12.csv.}

\item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from a further results file if he initial file contains no results. This filename is set here.}

\item{OUTPUTCOLSTART}{Column number in the simulation results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTCOLEND}{Column number in the simulation results file where the last output measure is. Only required if running the first method.}

\item{EXP_PARAMS}{Set of the value of all parameters being examined}

\item{PARAMETER}{Name of the parameter currently being analysed}

\item{PARAM_VAL}{Value of the parameter currently being analysed}
}
\value{
parameter set with median responses for all values
}
\description{
Generate the median responses for a set of parameter values
}
