% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatPomp_Csnippet.R
\name{spatPomp_Csnippet}
\alias{spatPomp_Csnippet}
\alias{spatPomp_Csnippet-character}
\alias{spatPomp_Csnippet,character-method}
\title{C snippets}
\usage{
\S4method{spatPomp_Csnippet}{character}(
  code,
  unit_statenames,
  unit_obsnames,
  unit_covarnames,
  unit_ivpnames,
  unit_paramnames,
  unit_vfnames
)
}
\arguments{
\item{code}{encodes a component of a spatiotemporal POMP model using \proglang{C} code}

\item{unit_statenames}{a subset of the \code{unit_statenames} slot of
the \code{spatPomp} object for which we are writing a model. This argument
allows the user to get variables that can be indexed conveniently to update
states and measurements in a loop. See examples for more details.}

\item{unit_obsnames}{a subset of the \code{unit_obsnames} slot of
the \code{spatPomp} object for which we are writing a model. This argument
allows the user to get variables that can be indexed conveniently to update
states and measurements in a loop. See examples for more details.}

\item{unit_covarnames}{if the model has covariate information for each unit,
the names of the covariates for each unit can be supplied to this argument.
This allows the user to get variables that can be indexed conveniently to
use incorporate the covariate information in a loop. See examples for more
details.}

\item{unit_ivpnames}{This argument is particularly useful when specifying the
\code{rinit} model component. The \code{paramnames} argument to the
\code{spatPomp()} constructor often has names for initial value
parameters for the latent states (e.g. \code{S1_0}, \code{S2_0} for the
the quantity of susceptibles at unit 1 and unit 2 at the initial time in an
SIR model). By supplying \code{unit_ivpnames}, we can get variables
that can be easily indexed to reference the initial value parameters (in
the previous example, \code{unit_ivpnames=c('S')} we can get a variable
named \code{S_0} that we can index as \code{S_0[0]} and \code{S_0[1]} to
refer to \code{S1_0} and \code{S2_0}). See examples for more details.}

\item{unit_paramnames}{This argument is particularly useful when there
are non-initial value parameters that are unit-specific.}

\item{unit_vfnames}{This argument is particularly useful when specifying the
\code{skeleton} model component. For all components of the latent state,
the user can assume a variable defining the time-derivative is pre-defined (e.g.
\code{DS1} and \code{DS2} for the time-derivative of the quantity of the
susceptibles at unit 1 and unit 2 in an SIR model). By supplying
\code{unit_vfnames}, we can get variables that can be easily indexed to
reference these variables (in the previous example,
setting \code{unit_vfnames=c('S')} gets us a variable
named \code{DS} that we can index as \code{DS[0]} and \code{DS[1]} to
refer to \code{DS1} and \code{DS2}). See examples for more details.}
}
\value{
An object of class \sQuote{Csnippet} which represents a model specification in C code.
}
\description{
\code{spatPomp_Csnippet()} is used to provide snippets of \proglang{C}
code that specify model components. It functions similarly to \code{Csnippet()} from
the \pkg{pomp} package; in fact, the output of \code{spatPomp_Csnippet} is an object
of class \code{Csnippet}.  It additionally provides some arguments that allow the user
to stay focused on model development in the spatiotemporal context  where
model size grows.
}
\examples{
# Set initial states for Brownian motion
bm_rinit <- spatPomp_Csnippet(
  unit_statenames = c("X"),
  unit_ivpnames = c("X"),
  code = "
    for (int u = 0; u < U; u++) {
      X[u]=X_0[u];
    }
  "
)
# Skeleton for Brownian motion
bm_skel <- spatPomp_Csnippet(
  unit_statenames = c("X"),
  unit_vfnames = c("X"),
  code = "
      for (int u = 0 ; u < U ; u++) {
        DX[u] = 0;
      }
  "
)
}
