% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified.random.R
\name{stratified.random}
\alias{stratified.random}
\title{Stratified random sample}
\usage{
stratified.random(x, strata, n = 10, reps = 1, replace = TRUE)
}
\arguments{
\item{x}{sp class SpatialDataFrame object (point, polygon, line, pixel)}

\item{strata}{Column in @data slot with stratification factor}

\item{n}{Number of random samples}

\item{reps}{Number of replicates per strata}

\item{replace}{Sampling with replacement (TRUE|FALSE)}
}
\value{
sp SpatialDataFrame object (same as input feature) containing random samples

}
\description{
Creates a stratified random sample of an sp class object

}
\note{

If replace=FALSE features are removed from consideration in subsequent replicates.
Conversely, if replace=TRUE, a feature can be selected multiple times across replicates. Not applicable if rep=1.


Depends: sp

}
\examples{
require(sp)
  data(meuse)
    coordinates(meuse) <- ~x+y

# Create stratified variable using quartile breaks
x1 <- cut(meuse@data[,'cadmium'], summary(meuse@data[,'cadmium'])[-4], include.lowest=TRUE)
  levels(x1) <- seq(1,nlevels(x1),1)
x2 <- cut(meuse@data[,'lead'], summary(meuse@data[,'lead'])[-4], include.lowest=TRUE)
  levels(x2) <- seq(1,nlevels(x2),1) 
meuse@data <- cbind(meuse@data, STRAT=paste(x1, x2, sep='.') ) 
   
# 2 replicates and replacement
ssample <- stratified.random(meuse, strata='STRAT', n=2, reps=2)

# 2 replicates and no replacement
ssample.nr <- stratified.random(meuse, strata='STRAT', n=2, reps=2, replace=FALSE)

# n=1 and reps=10 for sequential numbering of samples 
ssample.ct <- stratified.random(meuse, strata='STRAT', n=1, reps=10, replace=TRUE)

# Counts for each full strata (note; 2 strata have only 1 observsation)
tapply(meuse@data$STRAT, meuse@data$STRAT, length)

# Counts for each sampled strata, with replacement
tapply(ssample@data$STRAT, ssample@data$STRAT, length)

# Counts for each sampled strata, without replacement
tapply(ssample.nr@data$STRAT, ssample.nr@data$STRAT, length)

# Counts for each sampled strata, without replacement
tapply(ssample.ct@data$STRAT, ssample.ct@data$STRAT, length)

# Plot random samples colored by replacement
ssample@data$REP <- factor(ssample@data$REP)
  spplot(ssample, 'REP', col.regions=c('red','blue'))

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
 
}
\references{

Hudak, A.T., N.L. Crookston, J.S. Evans, M.J. Falkowski, A.M.S. Smith, P. Gessler and P. Morgan. (2006) Regression modelling and mapping of coniferous forest basal area and tree density from discrete-return lidar and multispectral satellite data. Canadian Journal of Remote Sensing 32: 126-138.

}

