% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.transect.R
\name{sampleTransect}
\alias{sampleTransect}
\title{Sample transect}
\usage{
sampleTransect(x, min.length, max.length, id = NULL, ...)
}
\arguments{
\item{x}{A sp point object}

\item{min.length}{Minimum length of transect(s)}

\item{max.length}{Maximum length of transect(s)}

\item{id}{A unique indetification column in x}

\item{...}{Additional arguments passed to sample.line}
}
\description{
Creates random transects from points and generates sample points along each transect
}
\note{
Function create random direction and length transects and then creates a point sample along each transect. The characteristic of the sample points are defined by arguments passed to the sample.line function
}
\examples{
library(sp)
data(meuse)
coordinates(meuse) <- ~x+y
proj4string(meuse) <- CRS("+init=epsg:28992")
meuse <- meuse[sample(1:nrow(meuse),10),]

transects <- sampleTransect(meuse, min.length=200, max.length=500, min.samp = 3)
  plot(transects$transects)
    plot(transects$samples, pch=20, add=TRUE)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

