% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissection.R
\name{dissection}
\alias{dissection}
\title{Dissection}
\usage{
dissection(x, s = 5, ...)
}
\arguments{
\item{x}{raster object}

\item{s}{Focal window size}

\item{...}{Additional arguments passed to raster::calc}
}
\value{
raster class object of Martonne's modified dissection
}
\description{
Calculates the Evans (1972) Martonne's modified dissection
}
\note{
Dissection is calculated as: ( z(s) - min(z(s)) ) / ( max(z(s)) - min(z(s)) )
}
\examples{
\dontrun{ 
  library(raster)
  data(elev)
  d <- dissection(elev, s=3)
    plot(d, main="dissection") 
}     

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
